/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.cycle;

import java.util.Optional;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.RequestHandlerExecutor;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycle
implements IRequestCycle,
IEventSink {
    private static final Logger log = LoggerFactory.getLogger(RequestCycle.class);
    private static final Logger logExtra = LoggerFactory.getLogger((String)"RequestCycleExtra");
    private Request request;
    private final Response originalResponse;
    private final IRequestMapper requestMapper;
    private final IExceptionMapper exceptionMapper;
    private final RequestCycleListenerCollection listeners;
    private UrlRenderer urlRenderer;
    private MetaDataEntry<?>[] metaData;
    private final long startTime;
    private final RequestHandlerExecutor requestHandlerExecutor;
    private Response activeResponse;

    public static RequestCycle get() {
        return ThreadContext.getRequestCycle();
    }

    private static void set(RequestCycle requestCycle) {
        ThreadContext.setRequestCycle(requestCycle);
    }

    public RequestCycle(RequestCycleContext context) {
        Args.notNull((Object)context, (String)"context");
        Args.notNull((Object)context.getRequest(), (String)"context.request");
        Args.notNull((Object)context.getResponse(), (String)"context.response");
        Args.notNull((Object)context.getRequestMapper(), (String)"context.requestMapper");
        Args.notNull((Object)context.getExceptionMapper(), (String)"context.exceptionMapper");
        this.listeners = new RequestCycleListenerCollection();
        this.startTime = System.currentTimeMillis();
        this.requestHandlerExecutor = new HandlerExecutor();
        this.activeResponse = context.getResponse();
        this.request = context.getRequest();
        this.originalResponse = context.getResponse();
        this.requestMapper = context.getRequestMapper();
        this.exceptionMapper = context.getExceptionMapper();
    }

    protected UrlRenderer newUrlRenderer() {
        return new UrlRenderer(this.getRequest());
    }

    public Response getOriginalResponse() {
        return this.originalResponse;
    }

    public final UrlRenderer getUrlRenderer() {
        if (this.urlRenderer == null) {
            this.urlRenderer = this.newUrlRenderer();
        }
        return this.urlRenderer;
    }

    protected IRequestHandler resolveRequestHandler() {
        return this.requestMapper.mapRequest(this.request);
    }

    protected int getExceptionRetryCount() {
        int retries = 10;
        if (Application.exists()) {
            retries = Application.get().getRequestCycleSettings().getExceptionRetryCount();
        }
        return retries;
    }

    public boolean processRequestAndDetach() {
        boolean result;
        try {
            result = this.processRequest();
        }
        finally {
            this.detach();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRequest() {
        block14: {
            try {
                RequestCycle.set(this);
                this.listeners.onBeginRequest(this);
                this.onBeginRequest();
                IRequestHandler handler = this.resolveRequestHandler();
                if (handler == null) {
                    log.debug("No suitable handler found for URL {}, falling back to container to process this request", (Object)this.request.getUrl());
                    break block14;
                }
                this.execute(handler);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                boolean bl = this.executeExceptionRequestHandler(exception, this.getExceptionRetryCount());
                return bl;
            }
            finally {
                try {
                    this.listeners.onEndRequest(this);
                    this.onEndRequest();
                }
                catch (RuntimeException e) {
                    log.error("Exception occurred during onEndRequest", (Throwable)e);
                }
                RequestCycle.set(null);
            }
        }
        return false;
    }

    private void execute(IRequestHandler handler) {
        Args.notNull((Object)handler, (String)"handler");
        while (handler != null) {
            try {
                this.listeners.onRequestHandlerResolved(this, handler);
                IRequestHandler next = this.requestHandlerExecutor.execute(handler);
                this.listeners.onRequestHandlerExecuted(this, handler);
                handler = next;
            }
            catch (RuntimeException e) {
                RequestHandlerExecutor.ReplaceHandlerException replacer = (RequestHandlerExecutor.ReplaceHandlerException)Exceptions.findCause((Throwable)e, RequestHandlerExecutor.ReplaceHandlerException.class);
                if (replacer == null) {
                    throw e;
                }
                if (replacer.getRemoveScheduled()) {
                    this.requestHandlerExecutor.schedule(null);
                }
                handler = replacer.getReplacementRequestHandler();
            }
        }
    }

    private boolean executeExceptionRequestHandler(Exception exception, int retryCount) {
        IRequestHandler handler = this.handleException(exception);
        if (handler == null) {
            log.error("Error during request processing. URL=" + this.request.getUrl(), (Throwable)exception);
            return false;
        }
        this.scheduleRequestHandlerAfterCurrent(null);
        try {
            this.listeners.onExceptionRequestHandlerResolved(this, handler, exception);
            this.execute(handler);
            return true;
        }
        catch (Exception e) {
            if (retryCount > 0) {
                return this.executeExceptionRequestHandler(exception, retryCount - 1);
            }
            log.error("Exception retry count exceeded", (Throwable)e);
            return false;
        }
    }

    protected IRequestHandler handleException(Exception e) {
        IRequestHandler handler;
        if (Application.exists() && Application.get().usesDevelopmentConfig()) {
            logExtra.warn("********************************");
            logExtra.warn("Handling the following exception", (Throwable)e);
            logExtra.warn("********************************");
        }
        if ((handler = this.listeners.onException(this, e)) != null) {
            return handler;
        }
        return this.exceptionMapper.map(e);
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public final <T> RequestCycle setMetaData(MetaDataKey<T> key, T object) {
        this.metaData = key.set(this.metaData, object);
        return this;
    }

    public final <T> T getMetaData(MetaDataKey<T> key) {
        return key.get(this.metaData);
    }

    public Url mapUrlFor(IRequestHandler handler) {
        Url url = this.requestMapper.mapHandler(handler);
        this.listeners.onUrlMapped(this, handler, url);
        return url;
    }

    public Url mapUrlFor(ResourceReference reference, PageParameters params) {
        return this.mapUrlFor(new ResourceReferenceRequestHandler(reference, params));
    }

    public final <C extends Page> Url mapUrlFor(Class<C> pageClass, PageParameters parameters) {
        BookmarkablePageRequestHandler handler = new BookmarkablePageRequestHandler(new PageProvider(pageClass, parameters));
        return this.mapUrlFor(handler);
    }

    public final CharSequence urlFor(ResourceReference reference, PageParameters params) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(reference, params);
        return this.urlFor(handler);
    }

    public final <C extends Page> CharSequence urlFor(Class<C> pageClass, PageParameters parameters) {
        BookmarkablePageRequestHandler handler = new BookmarkablePageRequestHandler(new PageProvider(pageClass, parameters));
        return this.urlFor(handler);
    }

    public CharSequence urlFor(IRequestHandler handler) {
        try {
            Url mappedUrl = this.mapUrlFor(handler);
            String url = this.renderUrl(mappedUrl, handler);
            return url;
        }
        catch (Exception x) {
            throw new WicketRuntimeException(String.format("An error occurred while generating an Url for handler '%s'", handler), x);
        }
    }

    private String renderUrl(Url url, IRequestHandler handler) {
        if (url != null) {
            boolean shouldEncodeStaticResource = Application.exists() && Application.get().getResourceSettings().isEncodeJSessionId();
            String renderedUrl = this.getUrlRenderer().renderUrl(url);
            if (handler instanceof ResourceReferenceRequestHandler) {
                ResourceReferenceRequestHandler rrrh = (ResourceReferenceRequestHandler)handler;
                IResource resource = rrrh.getResource();
                if (resource != null && !(resource instanceof IStaticCacheableResource) || shouldEncodeStaticResource) {
                    renderedUrl = this.getOriginalResponse().encodeURL((CharSequence)renderedUrl);
                }
            } else if (handler instanceof ResourceRequestHandler) {
                ResourceRequestHandler rrh = (ResourceRequestHandler)handler;
                IResource resource = rrh.getResource();
                if (resource != null && !(resource instanceof IStaticCacheableResource) || shouldEncodeStaticResource) {
                    renderedUrl = this.getOriginalResponse().encodeURL((CharSequence)renderedUrl);
                }
            } else {
                renderedUrl = this.getOriginalResponse().encodeURL((CharSequence)renderedUrl);
            }
            return renderedUrl;
        }
        return null;
    }

    public final void detach() {
        RequestCycle.set(this);
        try {
            this.onDetach();
        }
        finally {
            try {
                this.onInternalDetach();
            }
            finally {
                RequestCycle.set(null);
            }
        }
    }

    private void onInternalDetach() {
        IRequestLogger requestLogger;
        if (Session.exists()) {
            Session.get().internalDetach();
        }
        if (Application.exists() && (requestLogger = Application.get().getRequestLogger()) != null) {
            requestLogger.performLogging();
        }
    }

    public void onDetach() {
        try {
            this.requestHandlerExecutor.detach();
        }
        catch (RuntimeException exception) {
            this.handleDetachException(exception);
        }
        finally {
            this.listeners.onDetach(this);
        }
        if (Session.exists()) {
            Session.get().detach();
        }
    }

    private void handleDetachException(RuntimeException exception) {
        log.error("Error detaching RequestCycle", (Throwable)exception);
    }

    public void setResponsePage(IRequestablePage page) {
        if (page instanceof Page) {
            ((Page)page).setStatelessHint(false);
        }
        this.scheduleRequestHandlerAfterCurrent(new RenderPageRequestHandler(new PageProvider(page), RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT));
    }

    public void setResponsePage(Class<? extends IRequestablePage> pageClass) {
        this.setResponsePage(pageClass, null, RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT);
    }

    public void setResponsePage(Class<? extends IRequestablePage> pageClass, RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        this.setResponsePage(pageClass, null, redirectPolicy);
    }

    public void setResponsePage(Class<? extends IRequestablePage> pageClass, PageParameters parameters) {
        this.setResponsePage(pageClass, parameters, RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT);
    }

    public void setResponsePage(Class<? extends IRequestablePage> pageClass, PageParameters parameters, RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        PageProvider provider = new PageProvider(pageClass, parameters);
        this.scheduleRequestHandlerAfterCurrent(new RenderPageRequestHandler(provider, redirectPolicy));
    }

    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public void onEvent(IEvent<?> event) {
    }

    protected void onBeginRequest() {
    }

    protected void onEndRequest() {
        if (Session.exists()) {
            Session.get().endRequest();
        }
    }

    public RequestCycleListenerCollection getListeners() {
        return this.listeners;
    }

    public Response getResponse() {
        return this.activeResponse;
    }

    public Response setResponse(Response response) {
        Response current = this.activeResponse;
        this.activeResponse = response;
        return current;
    }

    public void scheduleRequestHandlerAfterCurrent(IRequestHandler handler) {
        this.requestHandlerExecutor.schedule(handler);
        if (handler != null) {
            this.listeners.onRequestHandlerScheduled(this, handler);
        }
    }

    public IRequestHandler getActiveRequestHandler() {
        return this.requestHandlerExecutor.getActive();
    }

    public IRequestHandler getRequestHandlerScheduledAfterCurrent() {
        return this.requestHandlerExecutor.next();
    }

    public void replaceAllRequestHandlers(IRequestHandler handler) {
        this.requestHandlerExecutor.replaceAll(handler);
    }

    public <T extends IRequestHandler> Optional<T> find(Class<T> type) {
        if (type == null) {
            return Optional.empty();
        }
        IRequestHandler result = this.getActiveRequestHandler();
        if (type.isInstance(result)) {
            return Optional.of(result);
        }
        result = this.getRequestHandlerScheduledAfterCurrent();
        if (type.isInstance(result)) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private class HandlerExecutor
    extends RequestHandlerExecutor {
        private HandlerExecutor() {
        }

        protected void respond(IRequestHandler handler) {
            Response originalResponse = RequestCycle.this.getResponse();
            try {
                handler.respond((IRequestCycle)RequestCycle.this);
            }
            finally {
                RequestCycle.this.setResponse(originalResponse);
            }
        }

        protected void detach(IRequestHandler handler) {
            handler.detach((IRequestCycle)RequestCycle.this);
        }
    }
}

