/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class AttrColumn<T extends AttributableTO>
extends AbstractColumn<T, String> {
    private static final long serialVersionUID = 2624734332447371372L;
    private final String name;
    private final SchemaType schemaType;

    public AttrColumn(String name, SchemaType schemaType) {
        super((IModel)new ResourceModel(name, name), (Object)(schemaType.name() + "#" + name));
        this.name = name;
        this.schemaType = schemaType;
    }

    public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId, IModel<T> rowModel) {
        ArrayList values = new ArrayList();
        switch (this.schemaType) {
            case PLAIN: {
                ((AttributableTO)rowModel.getObject()).getPlainAttr(this.name).ifPresent(attr -> values.addAll(attr.getValues()));
                break;
            }
            case DERIVED: {
                ((AttributableTO)rowModel.getObject()).getDerAttr(this.name).ifPresent(attr -> values.addAll(attr.getValues()));
                break;
            }
            case VIRTUAL: {
                ((AttributableTO)rowModel.getObject()).getVirAttr(this.name).ifPresent(attr -> values.addAll(attr.getValues()));
                break;
            }
        }
        if (values.isEmpty()) {
            cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
        } else if (values.size() == 1) {
            cellItem.add(new Component[]{new Label(componentId, (Serializable)values.get(0))});
        } else {
            cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((Object)values).toString()))});
        }
    }
}

