/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ConnObjects;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.status.ResourceStatusModal;
import org.apache.syncope.client.console.tasks.PropagationTasks;
import org.apache.syncope.client.console.tasks.PullTasks;
import org.apache.syncope.client.console.tasks.PushTasks;
import org.apache.syncope.client.console.tasks.SchedTasks;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.IndicatingOnConfirmAjaxLink;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceProvisionPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceWizardBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class TopologyTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -2025535531121434056L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private final WebMarkupContainer container;
    protected final BaseModal<Serializable> propTaskModal;
    protected final BaseModal<Serializable> schedTaskModal;
    protected final BaseModal<Serializable> provisionModal;
    private final BaseModal<Serializable> historyModal;

    public TopologyTogglePanel(String id, PageReference pageRef) {
        super(id, "topologyTogglePanel", pageRef);
        this.modal.size(Modal.Size.Large);
        this.setFooterVisibility(false);
        this.propTaskModal = new BaseModal("outer");
        this.propTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.propTaskModal});
        this.schedTaskModal = new BaseModal<Serializable>("outer"){
            private static final long serialVersionUID = 389935548143327858L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.schedTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.schedTaskModal});
        this.provisionModal = new BaseModal("outer");
        this.provisionModal.size(Modal.Size.Large);
        this.provisionModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.provisionModal});
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupPlaceholderTag(true);
        this.addInnerObject(new Component[]{this.container});
        this.container.add(new Component[]{this.getEmptyFragment()});
    }

    public void toggleWithContent(AjaxRequestTarget target, final TopologyNode node) {
        this.setHeader(target, node.getDisplayName());
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                TopologyTogglePanel.this.modal.show(false);
                TopologyTogglePanel.this.send((IEventSink)TopologyTogglePanel.this.pageRef.getPage(), Broadcast.DEPTH, new UpdateEvent(node.getKey(), target));
            }
        });
        switch (node.getKind()) {
            case SYNCOPE: {
                this.container.addOrReplace(new Component[]{this.getSyncopeFragment(this.pageRef)});
                break;
            }
            case CONNECTOR_SERVER: {
                this.container.addOrReplace(new Component[]{this.getLocationFragment(node, this.pageRef)});
                break;
            }
            case FS_PATH: {
                this.container.addOrReplace(new Component[]{this.getLocationFragment(node, this.pageRef)});
                break;
            }
            case CONNECTOR: {
                this.container.addOrReplace(new Component[]{this.getConnectorFragment(node, this.pageRef)});
                break;
            }
            case RESOURCE: {
                this.container.addOrReplace(new Component[]{this.getResourceFragment(node, this.pageRef)});
                break;
            }
            default: {
                this.container.addOrReplace(new Component[]{this.getEmptyFragment()});
            }
        }
        target.add(new Component[]{this.container});
        this.toggle(target, node, true);
    }

    private Fragment getEmptyFragment() {
        return new Fragment("actions", "emptyFragment", (MarkupContainer)this);
    }

    private Fragment getSyncopeFragment(final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "syncopeActions", (MarkupContainer)this);
        IndicatingOnConfirmAjaxLink<String> reload = new IndicatingOnConfirmAjaxLink<String>("reload", "connectors.confirm.reload", true){
            private static final long serialVersionUID = -2075933173666007020L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    TopologyTogglePanel.this.connectorRestClient.reload();
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While reloading all connectors", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        fragment.add(new Component[]{reload});
        MetaDataRoleAuthorizationStrategy.authorize((Component)reload, (Action)RENDER, (String)"CONNECTOR_RELOAD");
        IndicatingAjaxLink<String> tasks = new IndicatingAjaxLink<String>("tasks"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{TopologyTogglePanel.this.schedTaskModal.setContent(new SchedTasks(TopologyTogglePanel.this.schedTaskModal, pageRef))});
                TopologyTogglePanel.this.schedTaskModal.header((IModel)new ResourceModel("task.custom.list"));
                TopologyTogglePanel.this.schedTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        fragment.add(new Component[]{tasks});
        MetaDataRoleAuthorizationStrategy.authorize((Component)tasks, (Action)RENDER, (String)"TASK_LIST");
        return fragment;
    }

    private Fragment getLocationFragment(final TopologyNode node, final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "locationActions", (MarkupContainer)this);
        IndicatingAjaxLink<String> create = new IndicatingAjaxLink<String>("create"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ConnInstanceTO modelObject = new ConnInstanceTO();
                modelObject.setLocation(node.getKey());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modelObject);
                TopologyTogglePanel.this.modal.setFormModel(model);
                target.add(new Component[]{TopologyTogglePanel.this.modal.setContent(new ConnectorWizardBuilder(modelObject, pageRef).build("content", AjaxWizard.Mode.CREATE))});
                TopologyTogglePanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("connector.new"), node.getKey()))));
                TopologyTogglePanel.this.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        fragment.add(new Component[]{create});
        MetaDataRoleAuthorizationStrategy.authorize((Component)create, (Action)RENDER, (String)"CONNECTOR_CREATE");
        return fragment;
    }

    private Fragment getConnectorFragment(final TopologyNode node, final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "connectorActions", (MarkupContainer)this);
        IndicatingOnConfirmAjaxLink<String> delete = new IndicatingOnConfirmAjaxLink<String>("delete", true){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    TopologyTogglePanel.this.connectorRestClient.delete((String)String.class.cast(node.getKey()));
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", node.getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    TopologyTogglePanel.this.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting resource {}", (Object)node.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)delete, (Action)RENDER, (String)"CONNECTOR_DELETE");
        fragment.add(new Component[]{delete});
        IndicatingAjaxLink<String> create = new IndicatingAjaxLink<String>("create"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ResourceTO modelObject = new ResourceTO();
                modelObject.setConnector((String)String.class.cast(node.getKey()));
                modelObject.setConnectorDisplayName(node.getDisplayName());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modelObject);
                TopologyTogglePanel.this.modal.setFormModel(model);
                target.add(new Component[]{TopologyTogglePanel.this.modal.setContent(new ResourceWizardBuilder(modelObject, pageRef).build("content", AjaxWizard.Mode.CREATE))});
                TopologyTogglePanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.new"), node.getKey()))));
                TopologyTogglePanel.this.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)create, (Action)RENDER, (String)"RESOURCE_CREATE");
        fragment.add(new Component[]{create});
        IndicatingAjaxLink<String> edit = new IndicatingAjaxLink<String>("edit"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ConnInstanceTO connInstance = TopologyTogglePanel.this.connectorRestClient.read((String)String.class.cast(node.getKey()));
                CompoundPropertyModel model = new CompoundPropertyModel((Object)connInstance);
                TopologyTogglePanel.this.modal.setFormModel(model);
                target.add(new Component[]{TopologyTogglePanel.this.modal.setContent(new ConnectorWizardBuilder(connInstance, pageRef).build("content", SyncopeConsoleSession.get().owns("CONNECTOR_UPDATE", connInstance.getAdminRealm()) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                TopologyTogglePanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("connector.edit"), connInstance.getDisplayName()))));
                TopologyTogglePanel.this.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)edit, (Action)RENDER, (String)"CONNECTOR_READ");
        fragment.add(new Component[]{edit});
        IndicatingAjaxLink<String> history = new IndicatingAjaxLink<String>("history"){
            private static final long serialVersionUID = -1876519166660008562L;

            public void onClick(AjaxRequestTarget target) {
                ConnInstanceTO modelObject = TopologyTogglePanel.this.connectorRestClient.read(node.getKey());
                target.add(new Component[]{TopologyTogglePanel.this.historyModal.setContent(new AuditHistoryModal<ConnInstanceTO>(TopologyTogglePanel.this.historyModal, AuditElements.EventCategoryType.LOGIC, "ConnectorLogic", modelObject, "CONNECTOR_UPDATE", pageRef){
                    private static final long serialVersionUID = -3225348282675513648L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ConnInstanceTO updated = (ConnInstanceTO)MAPPER.readValue(json, ConnInstanceTO.class);
                            TopologyTogglePanel.this.connectorRestClient.update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            TopologyTogglePanel.this.toggle(target, false);
                        }
                        catch (Exception e) {
                            LOG.error("While restoring connector {}", (Object)node.getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                TopologyTogglePanel.this.historyModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("connector.menu.history"), node.getDisplayName()))));
                TopologyTogglePanel.this.historyModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)history, (Action)RENDER, (String)String.format("%s,%s", "CONNECTOR_READ", "AUDIT_LIST"));
        fragment.add(new Component[]{history});
        return fragment;
    }

    private Fragment getResourceFragment(final TopologyNode node, final PageReference pageRef) {
        Fragment fragment = new Fragment("actions", "resourceActions", (MarkupContainer)this);
        IndicatingOnConfirmAjaxLink<String> delete = new IndicatingOnConfirmAjaxLink<String>("delete", true){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    TopologyTogglePanel.this.resourceRestClient.delete(node.getKey());
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", node.getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    TopologyTogglePanel.this.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting resource {}", (Object)node.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)delete, (Action)RENDER, (String)"RESOURCE_DELETE");
        fragment.add(new Component[]{delete});
        IndicatingAjaxLink<String> edit = new IndicatingAjaxLink<String>("edit"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ResourceTO resource = TopologyTogglePanel.this.resourceRestClient.read(node.getKey());
                ConnInstanceTO connInstance = TopologyTogglePanel.this.connectorRestClient.read(resource.getConnector());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)resource);
                TopologyTogglePanel.this.modal.setFormModel(model);
                target.add(new Component[]{TopologyTogglePanel.this.modal.setContent(new ResourceWizardBuilder(resource, pageRef).build("content", SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", connInstance.getAdminRealm()) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                TopologyTogglePanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.edit"), node.getKey()))));
                TopologyTogglePanel.this.modal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)edit, (Action)RENDER, (String)"RESOURCE_READ");
        fragment.add(new Component[]{edit});
        IndicatingAjaxLink<String> status = new IndicatingAjaxLink<String>("reconciliation"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ResourceTO modelObject = TopologyTogglePanel.this.resourceRestClient.read(node.getKey());
                target.add(new Component[]{TopologyTogglePanel.this.propTaskModal.setContent(new ResourceStatusModal(TopologyTogglePanel.this.propTaskModal, pageRef, modelObject))});
                TopologyTogglePanel.this.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.reconciliation"), node.getKey()))));
                TopologyTogglePanel.this.propTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)status, (Action)RENDER, (String)"USER_UPDATE");
        fragment.add(new Component[]{status});
        IndicatingAjaxLink<String> provision = new IndicatingAjaxLink<String>("provision"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ResourceTO resource = TopologyTogglePanel.this.resourceRestClient.read(node.getKey());
                ConnInstanceTO connInstance = TopologyTogglePanel.this.connectorRestClient.read(resource.getConnector());
                if (SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", connInstance.getAdminRealm())) {
                    TopologyTogglePanel.this.provisionModal.addSubmitButton();
                } else {
                    TopologyTogglePanel.this.provisionModal.removeSubmitButton();
                }
                CompoundPropertyModel model = new CompoundPropertyModel((Object)resource);
                TopologyTogglePanel.this.provisionModal.setFormModel((Serializable)model);
                target.add(new Component[]{TopologyTogglePanel.this.provisionModal.setContent(new ResourceProvisionPanel(TopologyTogglePanel.this.provisionModal, resource, connInstance.getAdminRealm(), pageRef))});
                TopologyTogglePanel.this.provisionModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.edit"), node.getKey()))));
                TopologyTogglePanel.this.provisionModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)edit, (Action)RENDER, (String)"RESOURCE_READ");
        fragment.add(new Component[]{provision});
        IndicatingAjaxLink<String> explore = new IndicatingAjaxLink<String>("explore"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                ResourceTO resource = TopologyTogglePanel.this.resourceRestClient.read(node.getKey());
                target.add(new Component[]{TopologyTogglePanel.this.propTaskModal.setContent(new ConnObjects(resource, pageRef))});
                TopologyTogglePanel.this.propTaskModal.header((IModel)new StringResourceModel("resource.explore.list", (IModel)Model.of((Serializable)node)));
                TopologyTogglePanel.this.propTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)explore, (Action)RENDER, (String)"RESOURCE_LIST_CONNOBJECT");
        fragment.add(new Component[]{explore});
        IndicatingAjaxLink<String> propagation = new IndicatingAjaxLink<String>("propagation"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{TopologyTogglePanel.this.propTaskModal.setContent(new PropagationTasks(TopologyTogglePanel.this.propTaskModal, node.getKey(), pageRef))});
                TopologyTogglePanel.this.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.propagation.list"), node.getKey()))));
                TopologyTogglePanel.this.propTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)propagation, (Action)RENDER, (String)"TASK_LIST");
        fragment.add(new Component[]{propagation});
        IndicatingAjaxLink<String> pull = new IndicatingAjaxLink<String>("pull"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{TopologyTogglePanel.this.schedTaskModal.setContent(new PullTasks(TopologyTogglePanel.this.schedTaskModal, pageRef, node.getKey()))});
                TopologyTogglePanel.this.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.pull.list"), node.getKey()))));
                TopologyTogglePanel.this.schedTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)pull, (Action)RENDER, (String)"TASK_LIST");
        fragment.add(new Component[]{pull});
        IndicatingAjaxLink<String> push = new IndicatingAjaxLink<String>("push"){
            private static final long serialVersionUID = 3776750333491622263L;

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{TopologyTogglePanel.this.schedTaskModal.setContent(new PushTasks(TopologyTogglePanel.this.schedTaskModal, pageRef, node.getKey()))});
                TopologyTogglePanel.this.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("task.push.list"), node.getKey()))));
                TopologyTogglePanel.this.schedTaskModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)push, (Action)RENDER, (String)"TASK_LIST");
        fragment.add(new Component[]{push});
        IndicatingAjaxLink<String> history = new IndicatingAjaxLink<String>("history"){
            private static final long serialVersionUID = -1876519166660008562L;

            public void onClick(AjaxRequestTarget target) {
                ResourceTO modelObject = TopologyTogglePanel.this.resourceRestClient.read(node.getKey());
                target.add(new Component[]{TopologyTogglePanel.this.historyModal.setContent(new AuditHistoryModal<ResourceTO>(TopologyTogglePanel.this.historyModal, AuditElements.EventCategoryType.LOGIC, "ResourceLogic", modelObject, "RESOURCE_UPDATE", pageRef){
                    private static final long serialVersionUID = -3712506022627033811L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ResourceTO updated = (ResourceTO)MAPPER.readValue(json, ResourceTO.class);
                            TopologyTogglePanel.this.resourceRestClient.update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            TopologyTogglePanel.this.toggle(target, false);
                        }
                        catch (Exception e) {
                            LOG.error("While restoring resource {}", (Object)node.getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                TopologyTogglePanel.this.historyModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.getString("resource.menu.history"), node.getDisplayName()))));
                TopologyTogglePanel.this.historyModal.show(true);
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)history, (Action)RENDER, (String)String.format("%s,%s", "RESOURCE_READ", "AUDIT_LIST"));
        fragment.add(new Component[]{history});
        IndicatingOnConfirmAjaxLink<String> clone = new IndicatingOnConfirmAjaxLink<String>("clone", "confirmClone", true){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    ResourceTO resource = TopologyTogglePanel.this.resourceRestClient.read(node.getKey());
                    resource.setKey("Copy of " + resource.getKey());
                    if (resource.getOrgUnit() != null) {
                        resource.getOrgUnit().setKey(null);
                        resource.getOrgUnit().getItems().forEach(item -> item.setKey(null));
                    }
                    resource.getProvisions().forEach(provision -> {
                        provision.setKey(null);
                        if (provision.getMapping() != null) {
                            provision.getMapping().getItems().forEach(item -> item.setKey(null));
                            provision.getMapping().getLinkingItems().clear();
                        }
                        provision.getVirSchemas().clear();
                    });
                    TopologyTogglePanel.this.resourceRestClient.create(resource);
                    this.send((IEventSink)pageRef.getPage(), Broadcast.DEPTH, new AbstractResourceWizardBuilder.CreateEvent(resource.getKey(), resource.getKey(), TopologyNode.Kind.RESOURCE, (Serializable)((Object)resource.getConnector()), target));
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    TopologyTogglePanel.this.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While cloning resource {}", (Object)node.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)clone, (Action)RENDER, (String)"RESOURCE_CREATE");
        fragment.add(new Component[]{clone});
        return fragment;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
            AjaxWizard.NewItemFinishEvent item = (AjaxWizard.NewItemFinishEvent)AjaxWizard.NewItemFinishEvent.class.cast(event.getPayload());
            Serializable result = item.getResult();
            Optional<AjaxRequestTarget> target = item.getTarget();
            if (result != null && result instanceof ConnInstanceTO && target.isPresent()) {
                ConnInstanceTO conn = (ConnInstanceTO)ConnInstanceTO.class.cast(result);
                this.setHeader(target.get(), StringUtils.abbreviate((String)conn.getDisplayName(), (int)25));
            }
        }
    }

    public final class UpdateEvent {
        private final AjaxRequestTarget target;
        private final String key;

        public UpdateEvent(String key, AjaxRequestTarget target) {
            this.target = target;
            this.key = key;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKey() {
            return this.key;
        }
    }
}

