/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.search.SearchableFields;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchPanel
extends Panel {
    private static final long serialVersionUID = 5922413053568696414L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSearchPanel.class);
    protected AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    protected SchemaRestClient schemaRestClient = new SchemaRestClient();
    protected ResourceRestClient resourceRestClient = new ResourceRestClient();
    protected IModel<List<String>> dnames;
    protected IModel<Map<String, PlainSchemaTO>> anames;
    protected IModel<List<String>> resourceNames;
    protected IModel<List<SearchClause.Type>> types;
    protected IModel<List<String>> groupNames;
    protected IModel<List<String>> roleNames;
    protected IModel<List<String>> privilegeNames;
    protected IModel<List<SearchClause>> model;
    protected WebMarkupContainer searchFormContainer;
    protected final AnyTypeKind typeKind;
    protected final String type;
    protected final boolean required;
    protected final boolean enableSearch;
    protected final GroupRestClient groupRestClient = new GroupRestClient();

    protected AbstractSearchPanel(String id, AnyTypeKind kind, Builder<?> builder) {
        this(id, kind, kind.name(), builder);
    }

    protected AbstractSearchPanel(String id, AnyTypeKind kind, String type, Builder<?> builder) {
        super(id);
        this.populate();
        this.model = builder.model;
        this.typeKind = kind;
        this.type = type;
        this.required = builder.required;
        this.enableSearch = builder.enableSearch;
        this.setOutputMarkupId(true);
        this.searchFormContainer = new WebMarkupContainer("searchFormContainer");
        this.searchFormContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.searchFormContainer});
        Pair groupInfo = this.typeKind != AnyTypeKind.GROUP && SyncopeConsoleSession.get().owns("GROUP_SEARCH", new String[0]) ? Pair.of(this.groupNames, (Object)new LoadableDetachableModel<Integer>(){
            private static final long serialVersionUID = 7362833782319137329L;

            protected Integer load() {
                return AbstractSearchPanel.this.groupRestClient.count("/", null, null);
            }
        }) : Pair.of(this.groupNames, (Object)Model.of((Serializable)Integer.valueOf(0)));
        SearchClausePanel searchClausePanel = new SearchClausePanel("panel", "panel", (Model<SearchClause>)Model.of((Serializable)new SearchClause()), this.required, this.types, builder.customizer, this.anames, this.dnames, (Pair<IModel<List<String>>, IModel<Integer>>)groupInfo, this.roleNames, this.privilegeNames, this.resourceNames);
        if (this.enableSearch) {
            searchClausePanel.enableSearch(builder.resultContainer);
        }
        MultiFieldPanel.Builder<SearchClause> searchView = new MultiFieldPanel.Builder<SearchClause>(this.model){
            private static final long serialVersionUID = 1343431509987473047L;

            @Override
            protected SearchClause newModelObject() {
                return new SearchClause();
            }
        };
        this.searchFormContainer.add(new Component[]{searchView.build("search", "search", searchClausePanel).hideLabel()});
    }

    protected void populate() {
        this.dnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SearchableFields.get((Class)AbstractSearchPanel.this.typeKind.getTOClass());
            }
        };
        this.resourceNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return AbstractSearchPanel.this.resourceRestClient.list().stream().map(EntityTO::getKey).collect(Collectors.toList());
            }
        };
    }

    public IModel<List<SearchClause>> getModel() {
        return this.model;
    }

    public String getBackObjectType() {
        return this.type;
    }

    public Map<String, PlainSchemaTO> getAvailableSchemaTypes() {
        return (Map)this.anames.getObject();
    }

    public static abstract class Builder<T extends AbstractSearchPanel>
    implements Serializable {
        private static final long serialVersionUID = 6308997285778809578L;
        protected final IModel<List<SearchClause>> model;
        protected boolean required = true;
        protected boolean enableSearch = false;
        protected SearchClausePanel.Customizer customizer = new SearchClausePanel.Customizer(){
            private static final long serialVersionUID = 4449199405807453441L;
        };
        protected IEventSink resultContainer;

        public Builder(IModel<List<SearchClause>> model) {
            this.model = model;
        }

        public Builder<T> enableSearch(IEventSink resultContainer) {
            this.resultContainer = resultContainer;
            return this.enableSearch();
        }

        public Builder<T> enableSearch() {
            this.enableSearch = true;
            return this;
        }

        public Builder<T> customizer(SearchClausePanel.Customizer customizer) {
            this.customizer = customizer;
            return this;
        }

        public Builder<T> required(boolean required) {
            this.required = required;
            return this;
        }

        public abstract T build(String var1);
    }
}

