/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.any.MergeLinkedAccountsWizardModel;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class MergeLinkedAccountsReviewPanel
extends WizardStep {
    private static final long serialVersionUID = 1221037007528732347L;

    public MergeLinkedAccountsReviewPanel(MergeLinkedAccountsWizardModel wizardModel, PageReference pageReference) {
        this.setOutputMarkupId(true);
        this.setTitleModel((IModel)new StringResourceModel("mergeLinkedAccounts.reviewAccounts.title"));
        this.add(new Component[]{new LinkedAccountsReviewDirectoryPanel("linkedAccounts", pageReference, wizardModel)});
    }

    private static class LinkedAccountsReviewDirectoryPanel
    extends DirectoryPanel<LinkedAccountTO, LinkedAccountTO, LinkedAccountsDataProvider, ResourceRestClient> {
        private static final String PAGINATOR_ROWS = "linked.account.review.paginator.rows";
        private static final long serialVersionUID = 6005711052393825472L;
        private final MergeLinkedAccountsWizardModel wizardModel;

        LinkedAccountsReviewDirectoryPanel(String id, PageReference pageReference, MergeLinkedAccountsWizardModel wizardModel) {
            super(id, pageReference, true);
            this.restClient = new ResourceRestClient();
            this.wizardModel = wizardModel;
            this.modal.size(Modal.Size.Large);
            this.setOutputMarkupId(true);
            this.disableCheckBoxes();
            this.initResultTable();
        }

        @Override
        protected LinkedAccountsDataProvider dataProvider() {
            return new LinkedAccountsDataProvider(this.rows);
        }

        @Override
        protected String paginatorRowsKey() {
            return PAGINATOR_ROWS;
        }

        @Override
        protected List<IColumn<LinkedAccountTO, String>> getColumns() {
            ArrayList<IColumn<LinkedAccountTO, String>> columns = new ArrayList<IColumn<LinkedAccountTO, String>>();
            columns.add((IColumn<LinkedAccountTO, String>)new PropertyColumn((IModel)new ResourceModel("resource"), (Object)"resource", "resource"));
            columns.add((IColumn<LinkedAccountTO, String>)new PropertyColumn((IModel)new ResourceModel("connObjectKeyValue"), (Object)"connObjectKeyValue", "connObjectKeyValue"));
            columns.add((IColumn<LinkedAccountTO, String>)new PropertyColumn((IModel)new ResourceModel("username"), (Object)"username", "username"));
            columns.add((IColumn<LinkedAccountTO, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel("suspended"), "suspended", "suspended"));
            return columns;
        }

        @Override
        protected Collection<ActionLink.ActionType> getBatches() {
            return Collections.emptyList();
        }

        private List<LinkedAccountTO> previewAccounts() {
            UserTO mergingUser = this.wizardModel.getMergingUser();
            List<LinkedAccountTO> accounts = mergingUser.getLinkedAccounts().stream().map(acct -> {
                LinkedAccountTO linkedAccount = new LinkedAccountTO.Builder(acct.getResource(), acct.getConnObjectKeyValue()).password(acct.getPassword()).suspended(acct.isSuspended()).username(acct.getUsername()).build();
                linkedAccount.getPlainAttrs().addAll(acct.getPlainAttrs());
                linkedAccount.getPrivileges().addAll(acct.getPrivileges());
                return linkedAccount;
            }).collect(Collectors.toList());
            accounts.addAll(mergingUser.getResources().stream().map(resource -> {
                String connObjectKeyValue = ((ResourceRestClient)this.restClient).getConnObjectKeyValue((String)resource, mergingUser.getType(), mergingUser.getKey());
                return new LinkedAccountTO.Builder(resource, connObjectKeyValue).build();
            }).collect(Collectors.toList()));
            String connObjectKeyValue = ((ResourceRestClient)this.restClient).getConnObjectKeyValue(this.wizardModel.getResource().getKey(), mergingUser.getType(), mergingUser.getKey());
            LinkedAccountTO linkedAccount = new LinkedAccountTO.Builder(this.wizardModel.getResource().getKey(), connObjectKeyValue).password(mergingUser.getPassword()).suspended(mergingUser.isSuspended()).username(mergingUser.getUsername()).build();
            linkedAccount.getPlainAttrs().addAll(mergingUser.getPlainAttrs());
            linkedAccount.getPrivileges().addAll(mergingUser.getPrivileges());
            accounts.add(linkedAccount);
            return accounts;
        }

        protected final class LinkedAccountsDataProvider
        extends DirectoryDataProvider<LinkedAccountTO> {
            private static final long serialVersionUID = -185944053385660794L;
            private final SortableDataProviderComparator<LinkedAccountTO> comparator;

            private LinkedAccountsDataProvider(int paginatorRows) {
                super(paginatorRows);
                this.setSort("resource", SortOrder.ASCENDING);
                this.comparator = new SortableDataProviderComparator<LinkedAccountTO>(this);
            }

            public Iterator<LinkedAccountTO> iterator(long first, long count) {
                List list = LinkedAccountsReviewDirectoryPanel.this.previewAccounts();
                Collections.sort(list, this.comparator);
                return list.subList((int)first, (int)first + (int)count).iterator();
            }

            public long size() {
                return LinkedAccountsReviewDirectoryPanel.this.previewAccounts().size();
            }

            public IModel<LinkedAccountTO> model(LinkedAccountTO object) {
                return new CompoundPropertyModel((Object)object);
            }
        }
    }
}

