/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.Collapsible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.ConnObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CollectionPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public abstract class ConnObjectListViewPanel
extends Panel {
    private static final long serialVersionUID = 4986172040062752781L;
    private final AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    private final ReconciliationRestClient reconRestClient = new ReconciliationRestClient();
    private static final int SIZE = 10;
    private static final String STATUS = "Status";
    private String nextPageCookie;
    private AbstractSearchPanel searchPanel;
    private WebMarkupContainer arrows;
    private String anyType;
    private ResourceTO resource;

    protected ConnObjectListViewPanel(String id, final ResourceTO resource, final String anyType, final PageReference pageRef) {
        super(id);
        this.anyType = anyType;
        this.resource = resource;
        final Model model = Model.of((Serializable)Integer.valueOf(-1));
        final StringResourceModel res = new StringResourceModel("search.result", (Component)this, (IModel)new Model((Serializable)((Object)anyType)));
        Accordion accordion = new Accordion("accordionPanel", Collections.singletonList(new AbstractTab((IModel)res){
            private static final long serialVersionUID = 1037272333056449377L;

            public WebMarkupContainer getPanel(String panelId) {
                ConnObjectListViewPanel.this.searchPanel = ConnObjectListViewPanel.this.getSearchPanel(panelId, anyType);
                return ConnObjectListViewPanel.this.searchPanel;
            }
        }), (IModel)model){
            private static final long serialVersionUID = 6581261306163L;

            protected Component newTitle(String markupId, ITab tab, Collapsible.State state) {
                return new AjaxLink<Integer>(markupId){
                    private static final long serialVersionUID = 6584438659172L;

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("style", (CharSequence)"color: #337ab7");
                    }

                    public void onClick(AjaxRequestTarget target) {
                        model.setObject((Serializable)Integer.valueOf((Integer)model.getObject() == 0 ? -1 : 0));
                    }
                }.setBody((IModel)res);
            }
        };
        accordion.setOutputMarkupId(true);
        this.add(new Component[]{accordion.setEnabled(true).setVisible(true)});
        List<ConnObjectTO> listOfItems = this.reloadItems(resource.getKey(), anyType, null, null);
        ListViewPanel.Builder<ConnObjectTO> builder = new ListViewPanel.Builder<ConnObjectTO>(ConnObjectTO.class, pageRef){
            private static final long serialVersionUID = -8251750413385566738L;

            @Override
            protected Component getValueComponent(String key, ConnObjectTO bean) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)ConnObjectListViewPanel.STATUS)) {
                    ReconStatus status = ConnObjectListViewPanel.this.reconRestClient.status(new ReconQuery.Builder(anyType, resource.getKey()).connObjectKeyValue((String)((AttrTO)bean.getAttr("__UID__").get()).getValues().get(0)).build());
                    return status.getOnSyncope() == null ? StatusUtils.getLabel("field", "notfound icon", "Not found", "glyphicon glyphicon-remove-circle") : new Label("field", (IModel)Model.of()).add(new Behavior[]{new PopoverBehavior((IModel)Model.of(), (IModel)Model.of((Serializable)((Object)status.getAnyKey())), new PopoverConfig().withTitle(status.getMatchType() == MatchType.LINKED_ACCOUNT ? MatchType.LINKED_ACCOUNT.name() + ", " + AnyTypeKind.USER : status.getAnyTypeKind().name()).withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.left)){
                        private static final long serialVersionUID = -7867802555691605021L;

                        protected String createRelAttribute() {
                            return "field";
                        }

                        public void onComponentTag(Component component, ComponentTag tag) {
                            super.onComponentTag(component, tag);
                            tag.put("class", (CharSequence)"glyphicon glyphicon-ok-circle");
                        }
                    }});
                }
                Optional<AttrTO> attrTO = bean.getAttrs().stream().filter(object -> object.getSchema().equals(key)).findAny();
                return !attrTO.isPresent() || attrTO.get().getValues().isEmpty() ? new Label("field", (Serializable)((Object)"")) : new CollectionPanel("field", attrTO.get().getValues());
            }
        };
        builder.setReuseItem(false);
        builder.addAction(new ActionLink<ConnObjectTO>(){
            private static final long serialVersionUID = 7511002881490248598L;

            @Override
            public void onClick(AjaxRequestTarget target, ConnObjectTO modelObject) {
                ConnObjectListViewPanel.this.viewConnObject(modelObject, target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT").setItems(listOfItems).includes("__UID__", "__NAME__", "__ENABLE__").withChecks(ListViewPanel.CheckAvailability.NONE).setReuseItem(false);
        if (!StringUtils.equals((CharSequence)anyType, (CharSequence)"REALM")) {
            builder.addAction(new ActionLink<ConnObjectTO>(){
                private static final long serialVersionUID = 6377238742125L;

                @Override
                public void onClick(AjaxRequestTarget target, ConnObjectTO modelObject) {
                    String connObjectKeyValue = (String)((AttrTO)modelObject.getAttr("__UID__").get()).getValues().get(0);
                    ReconStatus status = ConnObjectListViewPanel.this.reconRestClient.status(new ReconQuery.Builder(anyType, resource.getKey()).connObjectKeyValue(connObjectKeyValue).build());
                    ConnObjectListViewPanel.this.pullConnObject(connObjectKeyValue, target, resource.getKey(), anyType, status.getRealm(), StringUtils.isNotBlank((CharSequence)status.getAnyKey()), pageRef);
                }
            }, ActionLink.ActionType.RECONCILIATION_PULL, "TASK_EXECUTE");
            builder.includes(STATUS);
        }
        this.add(new Component[]{builder.build("objs")});
        this.arrows = new WebMarkupContainer("arrows");
        this.add(new Component[]{this.arrows.setOutputMarkupId(true)});
        this.arrows.add(new Component[]{new AjaxLink<Serializable>("next"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                List listOfItems = ConnObjectListViewPanel.this.reloadItems(resource.getKey(), anyType, ConnObjectListViewPanel.this.nextPageCookie, ConnObjectListViewPanel.this.getFiql());
                target.add(new Component[]{ConnObjectListViewPanel.this.arrows});
                this.send((IEventSink)ConnObjectListViewPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(listOfItems, target));
            }

            public boolean isVisible() {
                return ConnObjectListViewPanel.this.nextPageCookie != null;
            }
        }});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
            this.nextPageCookie = null;
            AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
            List<ConnObjectTO> listOfItems = this.reloadItems(this.resource.getKey(), this.anyType, null, this.getFiql());
            target.add(new Component[]{this.arrows});
            this.send((IEventSink)this, Broadcast.DEPTH, new ListViewPanel.ListViewReload<ConnObjectTO>(listOfItems, target));
        } else {
            super.onEvent(event);
        }
    }

    protected abstract void viewConnObject(ConnObjectTO var1, AjaxRequestTarget var2);

    protected abstract void pullConnObject(String var1, AjaxRequestTarget var2, String var3, String var4, String var5, boolean var6, PageReference var7);

    private List<ConnObjectTO> reloadItems(String resource, String anyType, String cookie, String fiql) {
        Pair<String, List<ConnObjectTO>> items = new ResourceRestClient().searchConnObjects(resource, anyType, new ConnObjectTOQuery.Builder().size(Integer.valueOf(10)).pagedResultsCookie(cookie).fiql(fiql), (SortParam<String>)new SortParam((Object)"__UID__", true));
        this.nextPageCookie = (String)items.getLeft();
        return (List)items.getRight();
    }

    private AbstractSearchPanel getSearchPanel(String id, String anyType) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        SearchClause clause = new SearchClause();
        clauses.add(clause);
        clause.setComparator(SearchClause.Comparator.EQUALS);
        clause.setType(SearchClause.Type.ATTRIBUTE);
        clause.setProperty("");
        AnyTypeKind anyTypeKind = StringUtils.equals((CharSequence)anyType, (CharSequence)"REALM") || StringUtils.isEmpty((CharSequence)anyType) ? AnyTypeKind.ANY_OBJECT : this.anyTypeRestClient.read(anyType).getKind();
        return new ConnObjectSearchPanel.Builder(this.resource, anyTypeKind, anyType, (IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id);
    }

    private String getFiql() {
        return SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getConnObjectTOFiqlSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION);
    }
}

