/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.scim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Date;

public class SCIMGeneralConf
implements Serializable {
    private static final long serialVersionUID = 3228349133950736647L;
    private Date creationDate = new Date();
    private Date lastChangeDate = new Date();
    private int bulkMaxOperations = 1000;
    private int bulkMaxPayloadSize = 0x100000;
    private int filterMaxResults = 200;

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    public Date getLastChangeDate() {
        if (this.lastChangeDate != null) {
            return new Date(this.lastChangeDate.getTime());
        }
        return null;
    }

    public void setLastChangeDate(Date lastChangeDate) {
        this.lastChangeDate = lastChangeDate != null ? new Date(lastChangeDate.getTime()) : null;
    }

    @JsonIgnore
    public String getETagValue() {
        Date etagDate = this.getLastChangeDate() == null ? this.getCreationDate() : this.getLastChangeDate();
        return etagDate == null ? "" : String.valueOf(etagDate.getTime());
    }

    public int getBulkMaxOperations() {
        return this.bulkMaxOperations;
    }

    public void setBulkMaxOperations(int bulkMaxOperations) {
        this.bulkMaxOperations = bulkMaxOperations;
    }

    public int getBulkMaxPayloadSize() {
        return this.bulkMaxPayloadSize;
    }

    public void setBulkMaxPayloadSize(int bulkMaxPayloadSize) {
        this.bulkMaxPayloadSize = bulkMaxPayloadSize;
    }

    public int getFilterMaxResults() {
        return this.filterMaxResults;
    }

    public void setFilterMaxResults(int filterMaxResults) {
        this.filterMaxResults = filterMaxResults;
    }
}

