/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.InputStream;
import java.util.List;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.syncope.common.rest.api.service.ReconciliationService;
import org.apache.syncope.core.logic.ReconciliationLogic;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationServiceImpl
extends AbstractServiceImpl
implements ReconciliationService {
    @Autowired
    private ReconciliationLogic logic;

    private void validate(ReconQuery reconQuery) {
        if (reconQuery.getAnyKey() == null && reconQuery.getConnObjectKeyValue() == null || reconQuery.getAnyKey() != null && reconQuery.getConnObjectKeyValue() != null) {
            throw new ValidationException("Either provide anyKey or connObjectKeyValue, not both");
        }
    }

    public ReconStatus status(ReconQuery reconQuery) {
        this.validate(reconQuery);
        return this.logic.status(reconQuery);
    }

    public void push(ReconQuery reconQuery, PushTaskTO pushTask) {
        this.validate(reconQuery);
        this.logic.push(reconQuery, pushTask);
    }

    public void pull(ReconQuery reconQuery, PullTaskTO pullTask) {
        this.validate(reconQuery);
        this.logic.pull(reconQuery, pullTask);
    }

    public Response push(AnyQuery anyQuery, CSVPushSpec spec) {
        String realm = StringUtils.prependIfMissing((String)anyQuery.getRealm(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        SearchCond searchCond = StringUtils.isBlank((CharSequence)anyQuery.getFiql()) ? null : this.getSearchCond(anyQuery.getFiql(), realm);
        StreamingOutput sout = os -> this.logic.push(searchCond, anyQuery.getPage().intValue(), anyQuery.getSize().intValue(), this.getOrderByClauses(anyQuery.getOrderBy()), realm, spec, os);
        return Response.ok((Object)sout).type("text/csv").header("Content-Disposition", (Object)("attachment; filename=" + AuthContextUtils.getDomain() + ".csv")).build();
    }

    public List<ProvisioningReport> pull(CSVPullSpec spec, InputStream csv) {
        return this.logic.pull(spec, csv);
    }
}

