/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.table.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import net.tirasa.connid.bundles.db.table.security.EncodeAlgorithm;
import net.tirasa.connid.bundles.db.table.security.PasswordDecodingException;
import net.tirasa.connid.bundles.db.table.security.PasswordEncodingException;
import net.tirasa.connid.bundles.db.table.security.UnsupportedPasswordCharsetException;

public abstract class MessageDigestAlgorithm
extends EncodeAlgorithm {
    @Override
    public String encode(String clearPwd, String charsetName) throws PasswordEncodingException, UnsupportedPasswordCharsetException {
        if (charsetName == null) {
            throw new UnsupportedPasswordCharsetException("Invalid password charset.");
        }
        try {
            MessageDigest msgd = MessageDigest.getInstance(this.getName());
            msgd.reset();
            msgd.update(clearPwd.getBytes(charsetName));
            byte[] message = msgd.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < message.length; ++i) {
                String hex = Integer.toHexString(0xFF & message[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error((Throwable)uee, "Error encoding password charset", new Object[0]);
            throw new UnsupportedPasswordCharsetException(uee.getMessage());
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error encoding password", new Object[0]);
            throw new PasswordEncodingException(e.getMessage());
        }
    }

    @Override
    public String decode(String encodedPwd, String charsetName) throws PasswordDecodingException {
        if (charsetName == null) {
            throw new PasswordDecodingException("Invalid password charset.");
        }
        return encodedPwd;
    }

    @Override
    public final void setKey(String key) throws UnsupportedEncodingException {
    }
}

