/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.block;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.core.util.CssClassNames;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class WellBehavior
extends Behavior {
    private final IModel<Size> size;

    public WellBehavior() {
        this(Size.Default);
    }

    public WellBehavior(Size size) {
        this((IModel<Size>)Model.of((Serializable)((Object)((Size)Args.notNull((Object)size, (String)"size")))));
    }

    public WellBehavior(IModel<Size> sizeModel) {
        this.size = (IModel)Args.notNull(sizeModel, (String)"size");
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, CssClassNames.parse("well").add(((Size)this.size.getObject()).cssClassName()).asSet());
        Components.assertTag(component, tag, "div", "span");
    }

    public final WellBehavior setSize(Size size) {
        this.size.setObject((Object)size);
        return this;
    }

    public final Size getSize() {
        return (Size)this.size.getObject();
    }

    public void detach(Component component) {
        super.detach(component);
        this.size.detach();
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }

    public static enum Size implements ICssClassNameProvider
    {
        Default(""),
        Small("-sm"),
        Large("-lg");

        private final String cssName;

        private Size(String cssName) {
            this.cssName = cssName;
        }

        @Override
        public String cssClassName() {
            return this.equals(Default) ? "" : "well" + this.cssName;
        }
    }
}

