/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.apache.syncope.core.spring.security.jws.AccessTokenJwsSignatureVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SyncopeJWTSSOProvider
implements JWTSSOProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeJWTSSOProvider.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Resource(name="jwtIssuer")
    private String jwtIssuer;
    @Autowired
    private AccessTokenJwsSignatureVerifier delegate;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;

    @Override
    public String getIssuer() {
        return this.jwtIssuer;
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        return this.delegate.verify(headers, unsignedText, signature);
    }

    public JwsVerificationSignature createJwsVerificationSignature(JwsHeaders headers) {
        return this.delegate.createJwsVerificationSignature(headers);
    }

    @Override
    @Transactional(readOnly=true)
    public Pair<User, Set<SyncopeGrantedAuthority>> resolve(JwtClaims jwtClaims) {
        AccessToken accessToken;
        User user = this.userDAO.findByUsername(jwtClaims.getSubject());
        Set authorities = Collections.emptySet();
        if (user != null && (accessToken = this.accessTokenDAO.find(jwtClaims.getTokenId())) != null && accessToken.getAuthorities() != null) {
            try {
                authorities = (Set)POJOHelper.deserialize((String)ENCRYPTOR.decode(new String(accessToken.getAuthorities()), CipherAlgorithm.AES), (TypeReference)new TypeReference<Set<SyncopeGrantedAuthority>>(){});
            }
            catch (Throwable t) {
                LOG.error("Could not read stored authorities", t);
            }
        }
        return Pair.of((Object)user, authorities);
    }
}

