/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.springframework.security.core.GrantedAuthority;

public class SyncopeGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = -5647624636011919735L;
    @JsonProperty
    private final String entitlement;
    private final Set<String> realms = new TreeSet<String>();

    @JsonCreator
    public SyncopeGrantedAuthority(@JsonProperty(value="entitlement") String entitlement) {
        this.entitlement = entitlement;
    }

    public SyncopeGrantedAuthority(String entitlement, String realm) {
        this.entitlement = entitlement;
        this.realms.add(realm);
    }

    public boolean addRealm(String newRealm) {
        return RealmUtils.normalizingAddTo(this.realms, (String)newRealm);
    }

    public void addRealms(Collection<String> newRealms) {
        newRealms.forEach(newRealm -> this.addRealm((String)newRealm));
    }

    public Set<String> getRealms() {
        return Collections.unmodifiableSet(this.realms);
    }

    @JsonIgnore
    public String getAuthority() {
        return this.entitlement;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.entitlement).append(this.realms).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncopeGrantedAuthority other = (SyncopeGrantedAuthority)obj;
        return new EqualsBuilder().append((Object)this.entitlement, (Object)other.entitlement).append(this.realms, other.realms).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.entitlement).append(this.realms).build();
    }
}

