/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.PropertyUtils;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.jasypt.digest.StandardStringDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCrypt;

public final class Encryptor {
    private static final Logger LOG = LoggerFactory.getLogger(Encryptor.class);
    private static final Map<String, Encryptor> INSTANCES = new ConcurrentHashMap<String, Encryptor>();
    private static final String DEFAULT_SECRET_KEY = "1abcdefghilmnopqrstuvz2!";
    private static final int DEFAULT_SALT_ITERATIONS = 1;
    private static final int DEFAULT_SALT_SIZE_BYTES = 8;
    private static final boolean DEFAULT_IPOPSIER = true;
    private static final boolean DEFAULT_IPOSIMBD = true;
    private static final boolean DEFAULT_ULSSC = true;
    private static String SECRET_KEY;
    private static Integer SALT_ITERATIONS;
    private static Integer SALT_SIZE_BYTES;
    private static Boolean IPOPSIER;
    private static Boolean IPOSIMBD;
    private static Boolean ULSSC;
    private final Map<CipherAlgorithm, StandardStringDigester> digesters = new ConcurrentHashMap<CipherAlgorithm, StandardStringDigester>();
    private SecretKeySpec keySpec;

    public static Encryptor getInstance() {
        return Encryptor.getInstance(SECRET_KEY);
    }

    public static Encryptor getInstance(String secretKey) {
        String actualKey = StringUtils.isBlank((CharSequence)secretKey) ? DEFAULT_SECRET_KEY : secretKey;
        Encryptor instance = INSTANCES.get(actualKey);
        if (instance == null) {
            instance = new Encryptor(actualKey);
            INSTANCES.put(actualKey, instance);
        }
        return instance;
    }

    private Encryptor(String secretKey) {
        String actualKey = secretKey;
        if (actualKey.length() < 16) {
            StringBuilder actualKeyPadding = new StringBuilder(actualKey);
            int length = 16 - actualKey.length();
            String randomChars = SecureRandomUtils.generateRandomPassword(length);
            actualKeyPadding.append(randomChars);
            actualKey = actualKeyPadding.toString();
            LOG.warn("The secret key is too short (< 16), adding some random characters. Passwords encrypted with AES and this key will not be recoverable as a result if the container is restarted.");
        }
        try {
            this.keySpec = new SecretKeySpec(ArrayUtils.subarray((byte[])actualKey.getBytes(StandardCharsets.UTF_8), (int)0, (int)16), CipherAlgorithm.AES.getAlgorithm());
        }
        catch (Exception e) {
            LOG.error("Error during key specification", (Throwable)e);
        }
    }

    public String encode(String value, CipherAlgorithm cipherAlgorithm) throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String encoded = null;
        if (value != null) {
            if (cipherAlgorithm == null || cipherAlgorithm == CipherAlgorithm.AES) {
                Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
                cipher.init(1, this.keySpec);
                encoded = Base64.getEncoder().encodeToString(cipher.doFinal(value.getBytes(StandardCharsets.UTF_8)));
            } else {
                encoded = cipherAlgorithm == CipherAlgorithm.BCRYPT ? BCrypt.hashpw((String)value, (String)BCrypt.gensalt()) : this.getDigester(cipherAlgorithm).digest(value);
            }
        }
        return encoded;
    }

    public boolean verify(String value, CipherAlgorithm cipherAlgorithm, String encoded) {
        boolean verified = false;
        try {
            if (value != null) {
                verified = cipherAlgorithm == null || cipherAlgorithm == CipherAlgorithm.AES ? this.encode(value, cipherAlgorithm).equals(encoded) : (cipherAlgorithm == CipherAlgorithm.BCRYPT ? BCrypt.checkpw((String)value, (String)encoded) : this.getDigester(cipherAlgorithm).matches(value, encoded));
            }
        }
        catch (Exception e) {
            LOG.error("Could not verify encoded value", (Throwable)e);
        }
        return verified;
    }

    public String decode(String encoded, CipherAlgorithm cipherAlgorithm) throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String decoded = null;
        if (encoded != null && cipherAlgorithm == CipherAlgorithm.AES) {
            Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
            cipher.init(2, this.keySpec);
            decoded = new String(cipher.doFinal(Base64.getDecoder().decode(encoded)), StandardCharsets.UTF_8);
        }
        return decoded;
    }

    private StandardStringDigester getDigester(CipherAlgorithm cipherAlgorithm) {
        StandardStringDigester digester = this.digesters.get(cipherAlgorithm);
        if (digester == null) {
            digester = new StandardStringDigester();
            if (cipherAlgorithm.getAlgorithm().startsWith("S-")) {
                digester.setAlgorithm(cipherAlgorithm.getAlgorithm().replaceFirst("S\\-", ""));
                digester.setIterations(SALT_ITERATIONS.intValue());
                digester.setSaltSizeBytes(SALT_SIZE_BYTES.intValue());
                digester.setInvertPositionOfPlainSaltInEncryptionResults(IPOPSIER.booleanValue());
                digester.setInvertPositionOfSaltInMessageBeforeDigesting(IPOSIMBD.booleanValue());
                digester.setUseLenientSaltSizeCheck(ULSSC.booleanValue());
            } else {
                digester.setAlgorithm(cipherAlgorithm.getAlgorithm());
                digester.setIterations(1);
                digester.setSaltSizeBytes(0);
            }
            digester.setStringOutputType("hexadecimal");
            this.digesters.put(cipherAlgorithm, digester);
        }
        return digester;
    }

    static {
        try {
            Properties props = (Properties)PropertyUtils.read(Encryptor.class, (String)"security.properties", (String)"conf.directory").getLeft();
            SECRET_KEY = props.getProperty("secretKey");
            SALT_ITERATIONS = Integer.valueOf(props.getProperty("digester.saltIterations"));
            SALT_SIZE_BYTES = Integer.valueOf(props.getProperty("digester.saltSizeBytes"));
            IPOPSIER = Boolean.valueOf(props.getProperty("digester.invertPositionOfPlainSaltInEncryptionResults"));
            IPOSIMBD = Boolean.valueOf(props.getProperty("digester.invertPositionOfSaltInMessageBeforeDigesting"));
            ULSSC = Boolean.valueOf(props.getProperty("digester.useLenientSaltSizeCheck"));
        }
        catch (Exception e) {
            LOG.error("Could not read security parameters", (Throwable)e);
        }
        if (SECRET_KEY == null) {
            SECRET_KEY = DEFAULT_SECRET_KEY;
            LOG.debug("secretKey not found, reverting to default");
        }
        if (SALT_ITERATIONS == null) {
            SALT_ITERATIONS = 1;
            LOG.debug("digester.saltIterations not found, reverting to default");
        }
        if (SALT_SIZE_BYTES == null) {
            SALT_SIZE_BYTES = 8;
            LOG.debug("digester.saltSizeBytes not found, reverting to default");
        }
        if (IPOPSIER == null) {
            IPOPSIER = true;
            LOG.debug("digester.invertPositionOfPlainSaltInEncryptionResults not found, reverting to default");
        }
        if (IPOSIMBD == null) {
            IPOSIMBD = true;
            LOG.debug("digester.invertPositionOfSaltInMessageBeforeDigesting not found, reverting to default");
        }
        if (ULSSC == null) {
            ULSSC = true;
            LOG.debug("digester.useLenientSaltSizeCheck not found, reverting to default");
        }
    }
}

