/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.containers.jboss;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import org.apache.syncope.installer.containers.AbstractContainer;
import org.apache.syncope.installer.containers.jboss.JBossAddResponse;
import org.apache.syncope.installer.containers.jboss.JBossDeployRequestContent;
import org.apache.syncope.installer.utilities.HttpUtils;
import org.apache.syncope.installer.utilities.JsonUtils;

public class JBoss
extends AbstractContainer {
    private final String addContentUrl = "http://%s:%s/management/add-content";
    private final String enableUrl = "http://%s:%s/management/";
    private final boolean jbossSsl;
    private final String jbossHost;
    private final String jbossManagementPort;
    private final String installPath;
    private final String artifactId;
    private final HttpUtils httpUtils;

    public JBoss(boolean jbossSsl, String jbossHost, String jbossManagementPort, String jbossAdminUsername, String jbossAdminPassword, String installPath, String artifactId, AbstractUIProcessHandler handler) {
        this.jbossSsl = jbossSsl;
        this.jbossHost = jbossHost;
        this.jbossManagementPort = jbossManagementPort;
        this.installPath = installPath;
        this.artifactId = artifactId;
        this.httpUtils = new HttpUtils(jbossSsl, jbossHost, jbossManagementPort, jbossAdminUsername, jbossAdminPassword, handler);
    }

    public boolean deployCore() {
        return this.deploy("%s/%s/core/target/syncope.war", "syncope.war");
    }

    public boolean deployConsole() {
        return this.deploy("%s/%s/console/target/syncope-console.war", "syncope-console.war");
    }

    public boolean deployEnduser() {
        return this.deploy("%s/%s/enduser/target/syncope-enduser.war", "syncope-console.war");
    }

    public boolean deploy(String whatDeploy, String warName) {
        String responseBodyAsString = this.httpUtils.postWithDigestAuth(String.format("http://%s:%s/management/add-content", this.jbossHost, this.jbossManagementPort), String.format(whatDeploy, this.installPath, this.artifactId));
        JBossAddResponse jBossAddResponse = JsonUtils.jBossAddResponse(responseBodyAsString);
        JBossDeployRequestContent jBossDeployRequestContent = new JBossDeployRequestContent(jBossAddResponse.getResult().getBytesValue(), warName);
        int status = this.httpUtils.postWithStringEntity(String.format("http://%s:%s/management/", this.jbossHost, this.jbossManagementPort), JsonUtils.jBossDeployRequestContent(jBossDeployRequestContent));
        return status == 200;
    }
}

