/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.upgrade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.UUID;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.FileSchemaFactory;
import org.apache.openjpa.jdbc.schema.SchemaFactory;
import org.apache.openjpa.jdbc.schema.SimpleDriverDataSource;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.syncope.core.upgrade.WiserSchemaTool;

public final class GenerateUpgradeSQL {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static Writer OUT = new PrintWriter(System.out);

    public static void setWriter(Writer out) {
        OUT = out;
    }

    private static void upgrade(Connection conn) throws SQLException, IOException {
        String actionClassName;
        String actionClassName22;
        String implementationId;
        String serializedInstance;
        String id2;
        String implementationId2;
        String transformerClassName;
        String itemId2;
        Throwable throwable;
        ResultSet rs;
        OUT.write("UPDATE SyncopeUser SET mustChangePassword=0 WHERE mustChangePassword IS NULL;\n");
        OUT.write("UPDATE VirSchema SET readonly=0 WHERE readonly IS NULL;\n");
        OUT.write("UPDATE ExternalResource SET overrideCapabilities=0 WHERE overrideCapabilities IS NULL;\n");
        OUT.write("UPDATE OrgUnit SET ignoreCaseMatch=0;\n");
        try (Statement stmt = conn.createStatement();){
            rs = stmt.executeQuery("SELECT orgUnitItem_id,transformerClassName FROM OrgUnitItem_Transformer");
            throwable = null;
            try {
                while (rs.next()) {
                    itemId2 = rs.getString(1);
                    transformerClassName = rs.getString(2);
                    implementationId2 = "OrgUnitItemTransformer_" + transformerClassName + "_" + itemId2;
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + implementationId2 + "','ITEM_TRANSFORMER','JAVA','" + transformerClassName + "');\n");
                    OUT.write("INSERT INTO OrgUnitItemTransformer(item_id,implementation_id) VALUES('" + itemId2 + "','" + implementationId2 + "');\n");
                }
            }
            catch (Throwable itemId2) {
                throwable = itemId2;
                throw itemId2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable itemId2) {
                            throwable.addSuppressed(itemId2);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        OUT.write("DROP TABLE OrgUnitItem_Transformer;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT validatorClass FROM PlainSchema WHERE validatorClass IS NOT NULL");
            throwable = null;
            try {
                while (rs.next()) {
                    String validatorClass = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + validatorClass + "','VALIDATOR','JAVA','" + validatorClass + "');\n");
                }
            }
            catch (Throwable validatorClass) {
                throwable = validatorClass;
                throw validatorClass;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable validatorClass) {
                            throwable.addSuppressed(validatorClass);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs2) {
            var2_2 = rs2;
            throw rs2;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs2) {
                        var2_2.addSuppressed(rs2);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("UPDATE PlainSchema SET validator_id=validatorClass;\n");
        OUT.write("ALTER TABLE PlainSchema DROP COLUMN validatorClass;\n");
        OUT.write("UPDATE Provision SET ignoreCaseMatch=0;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT id,specification FROM PullPolicy WHERE specification IS NOT NULL");
            throwable = null;
            try {
                while (rs.next()) {
                    id2 = rs.getString(1);
                    ObjectNode specification = (ObjectNode)MAPPER.readTree(rs.getString(2));
                    if (specification.has("conflictResolutionAction")) {
                        OUT.write("UPDATE PullPolicy SET conflictResolutionAction='" + specification.get("conflictResolutionAction").asText() + "' WHERE id='" + id2 + "';\n");
                    }
                    if (!specification.has("correlationRules")) continue;
                    specification.get("correlationRules").fields().forEachRemaining(entry -> {
                        ObjectNode body = MAPPER.createObjectNode();
                        try {
                            String pullRuleClass = ((JsonNode)entry.getValue()).asText();
                            if (pullRuleClass.contains("org.apache.syncope")) {
                                String confClassName = "org.apache.syncope.common.lib.policy." + pullRuleClass.substring(pullRuleClass.lastIndexOf(".")).replace(".", "") + "Conf";
                                body.put("@class", confClassName);
                                body.put("name", confClassName);
                            } else {
                                body.put("@class", "org.apache.syncope.common.lib.policy.DefaultPullCorrelationRuleConf");
                                body.put("name", "org.apache.syncope.common.lib.policy.DefaultPullCorrelationRuleConf");
                                body.set("schemas", (JsonNode)entry.getValue());
                            }
                            String implementationId = "PullCorrelationRule_" + (String)entry.getKey() + "_" + id2;
                            OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + implementationId + "','PULL_CORRELATION_RULE','JAVA','" + MAPPER.writeValueAsString((Object)body) + "');\n");
                            OUT.write("INSERT INTO PullCorrelationRuleEntity(id,pullPolicy_id,anyType_id,implementation_id) VALUES('" + UUID.randomUUID().toString() + "','" + id2 + "','" + (String)entry.getKey() + "','" + implementationId + "');\n");
                        }
                        catch (IOException e) {
                            System.err.println("Unexpected error: " + e.getMessage());
                            System.exit(2);
                        }
                    });
                }
                OUT.write("ALTER TABLE PullPolicy DROP COLUMN specification;\n");
            }
            catch (Throwable id2) {
                throwable = id2;
                throw id2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable id2) {
                            throwable.addSuppressed(id2);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs3) {
            var2_2 = rs3;
            throw rs3;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs3) {
                        var2_2.addSuppressed(rs3);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT id,accountPolicy_id,serializedInstance FROM AccountRuleConfInstance");
            throwable = null;
            try {
                while (rs.next()) {
                    id2 = rs.getString(1);
                    String accountPolicyId = rs.getString(2);
                    serializedInstance = rs.getString(3);
                    implementationId = "AccountRule_" + accountPolicyId + "_" + id2;
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + implementationId + "','ACCOUNT_RULE','JAVA','" + serializedInstance + "');\n");
                    OUT.write("INSERT INTO AccountPolicyRule(policy_id,implementation_id) VALUES('" + accountPolicyId + "','" + implementationId + "');\n");
                }
            }
            catch (Throwable id3) {
                throwable = id3;
                throw id3;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable id3) {
                            throwable.addSuppressed(id3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs4) {
            var2_2 = rs4;
            throw rs4;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs4) {
                        var2_2.addSuppressed(rs4);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE AccountRuleConfInstance;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT id,passwordPolicy_id,serializedInstance FROM PasswordRuleConfInstance");
            throwable = null;
            try {
                while (rs.next()) {
                    id2 = rs.getString(1);
                    String passwordPolicyId = rs.getString(2);
                    serializedInstance = rs.getString(3);
                    implementationId = "PasswordRule_" + passwordPolicyId + "_" + id2;
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + implementationId + "','PASSWORD_RULE','JAVA','" + serializedInstance + "');\n");
                    OUT.write("INSERT INTO PasswordPolicyRule(policy_id,implementation_id) VALUES('" + passwordPolicyId + "','" + implementationId + "');\n");
                }
            }
            catch (Throwable id4) {
                throwable = id4;
                throw id4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable id4) {
                            throwable.addSuppressed(id4);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs5) {
            var2_2 = rs5;
            throw rs5;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs5) {
                        var2_2.addSuppressed(rs5);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE PasswordRuleConfInstance;\n");
        OUT.write("UPDATE Task SET remediation=0;\n");
        OUT.write("UPDATE Task SET active=0 WHERE active IS NULL;\n");
        OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('PullJobDelegate','TASKJOB_DELEGATE','JAVA','org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate');\n");
        OUT.write("UPDATE Task SET jobDelegate_id='PullJobDelegate' WHERE DTYPE='PullTask';\n");
        OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('PushJobDelegate','TASKJOB_DELEGATE','JAVA','org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate');\n");
        OUT.write("UPDATE Task SET jobDelegate_id='PushJobDelegate' WHERE DTYPE='PushTask';\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT jobDelegateClassName FROM Task WHERE jobDelegateClassName IS NOT NULL");
            throwable = null;
            try {
                while (rs.next()) {
                    String jobDelegateClassName = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + jobDelegateClassName + "','TASKJOB_DELEGATE','JAVA','" + jobDelegateClassName + "');\n");
                }
            }
            catch (Throwable jobDelegateClassName) {
                throwable = jobDelegateClassName;
                throw jobDelegateClassName;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable jobDelegateClassName) {
                            throwable.addSuppressed(jobDelegateClassName);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs6) {
            var2_2 = rs6;
            throw rs6;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs6) {
                        var2_2.addSuppressed(rs6);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("UPDATE Task SET jobDelegate_id=jobDelegateClassName;\n");
        OUT.write("ALTER TABLE Task DROP COLUMN jobDelegateClassName;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT actionClassName FROM PullTask_actionsClassNames");
            throwable = null;
            try {
                while (rs.next()) {
                    actionClassName22 = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + actionClassName22 + "','PULL_ACTIONS','JAVA','" + actionClassName22 + "');\n");
                }
            }
            catch (Throwable actionClassName22) {
                throwable = actionClassName22;
                throw actionClassName22;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable actionClassName22) {
                            throwable.addSuppressed(actionClassName22);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs7) {
            var2_2 = rs7;
            throw rs7;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs7) {
                        var2_2.addSuppressed(rs7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT pullTask_id,actionClassName FROM PullTask_actionsClassNames");
            throwable = null;
            try {
                while (rs.next()) {
                    String pullTaskId = rs.getString(1);
                    actionClassName = rs.getString(2);
                    OUT.write("INSERT INTO PullTaskAction(task_id,implementation_id) VALUES('" + pullTaskId + "','" + actionClassName + "');\n");
                }
            }
            catch (Throwable pullTaskId) {
                throwable = pullTaskId;
                throw pullTaskId;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable pullTaskId) {
                            throwable.addSuppressed(pullTaskId);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs8) {
            var2_2 = rs8;
            throw rs8;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs8) {
                        var2_2.addSuppressed(rs8);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE PullTask_actionsClassNames;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT actionClassName FROM PushTask_actionsClassNames");
            throwable = null;
            try {
                while (rs.next()) {
                    actionClassName22 = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + actionClassName22 + "','PUSH_ACTIONS','JAVA','" + actionClassName22 + "');\n");
                }
            }
            catch (Throwable actionClassName3) {
                throwable = actionClassName3;
                throw actionClassName3;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable actionClassName3) {
                            throwable.addSuppressed(actionClassName3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs9) {
            var2_2 = rs9;
            throw rs9;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs9) {
                        var2_2.addSuppressed(rs9);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT pushTask_id,actionClassName FROM PushTask_actionsClassNames");
            throwable = null;
            try {
                while (rs.next()) {
                    String pushTaskId = rs.getString(1);
                    actionClassName = rs.getString(2);
                    OUT.write("INSERT INTO PushTaskAction(task_id,implementation_id) VALUES('" + pushTaskId + "','" + actionClassName + "');\n");
                }
            }
            catch (Throwable pushTaskId) {
                throwable = pushTaskId;
                throw pushTaskId;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable pushTaskId) {
                            throwable.addSuppressed(pushTaskId);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs10) {
            var2_2 = rs10;
            throw rs10;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs10) {
                        var2_2.addSuppressed(rs10);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE PushTask_actionsClassNames;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT actionClassName FROM ExternalResource_PropActions");
            throwable = null;
            try {
                while (rs.next()) {
                    actionClassName22 = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + actionClassName22 + "','PROPAGATION_ACTIONS','JAVA','" + actionClassName22 + "');\n");
                }
            }
            catch (Throwable actionClassName4) {
                throwable = actionClassName4;
                throw actionClassName4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable actionClassName4) {
                            throwable.addSuppressed(actionClassName4);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs11) {
            var2_2 = rs11;
            throw rs11;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs11) {
                        var2_2.addSuppressed(rs11);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT resource_id,actionClassName FROM ExternalResource_PropActions");
            throwable = null;
            try {
                while (rs.next()) {
                    String resourceId = rs.getString(1);
                    actionClassName = rs.getString(2);
                    OUT.write("INSERT INTO ExternalResourcePropAction(resource_id,implementation_id) VALUES('" + resourceId + "','" + actionClassName + "');\n");
                }
            }
            catch (Throwable resourceId) {
                throwable = resourceId;
                throw resourceId;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable resourceId) {
                            throwable.addSuppressed(resourceId);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs12) {
            var2_2 = rs12;
            throw rs12;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs12) {
                        var2_2.addSuppressed(rs12);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE ExternalResource_PropActions;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT actionClassName FROM Realm_actionsClassNames");
            throwable = null;
            try {
                while (rs.next()) {
                    actionClassName22 = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + actionClassName22 + "','LOGIC_ACTIONS','JAVA','" + actionClassName22 + "');\n");
                }
            }
            catch (Throwable actionClassName5) {
                throwable = actionClassName5;
                throw actionClassName5;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable actionClassName5) {
                            throwable.addSuppressed(actionClassName5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs13) {
            var2_2 = rs13;
            throw rs13;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs13) {
                        var2_2.addSuppressed(rs13);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT realm_id,actionClassName FROM Realm_actionsClassNames");
            throwable = null;
            try {
                while (rs.next()) {
                    String realmId = rs.getString(1);
                    actionClassName = rs.getString(2);
                    OUT.write("INSERT INTO RealmAction(realm_id,implementation_id) VALUES('" + realmId + "','" + actionClassName + "');\n");
                }
            }
            catch (Throwable realmId) {
                throwable = realmId;
                throw realmId;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable realmId) {
                            throwable.addSuppressed(realmId);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs14) {
            var2_2 = rs14;
            throw rs14;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs14) {
                        var2_2.addSuppressed(rs14);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE Realm_actionsClassNames;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT id,report_id,serializedInstance FROM ReportletConfInstance");
            throwable = null;
            try {
                while (rs.next()) {
                    id2 = rs.getString(1);
                    String reportId = rs.getString(2);
                    serializedInstance = rs.getString(3);
                    implementationId = "Reportlet_" + reportId + "_" + id2;
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + implementationId + "','REPORTLET','JAVA','" + serializedInstance + "');\n");
                    OUT.write("INSERT INTO ReportReportlet(report_id,implementation_id) VALUES('" + reportId + "','" + implementationId + "');\n");
                }
            }
            catch (Throwable id5) {
                throwable = id5;
                throw id5;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable id5) {
                            throwable.addSuppressed(id5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs15) {
            var2_2 = rs15;
            throw rs15;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs15) {
                        var2_2.addSuppressed(rs15);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE ReportletConfInstance;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT mappingItem_id,transformerClassName FROM MappingItem_Transformer");
            throwable = null;
            try {
                while (rs.next()) {
                    itemId2 = rs.getString(1);
                    transformerClassName = rs.getString(2);
                    implementationId2 = "MappingItemTransformer_" + transformerClassName + "_" + itemId2;
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + implementationId2 + "','ITEM_TRANSFORMER','JAVA','" + transformerClassName + "');\n");
                    OUT.write("INSERT INTO MappingItemTransformer(item_id,implementation_id) VALUES('" + itemId2 + "','" + implementationId2 + "');\n");
                }
            }
            catch (Throwable itemId3) {
                throwable = itemId3;
                throw itemId3;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable itemId3) {
                            throwable.addSuppressed(itemId3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs16) {
            var2_2 = rs16;
            throw rs16;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs16) {
                        var2_2.addSuppressed(rs16);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("DROP TABLE MappingItem_Transformer;\n");
        stmt = conn.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT DISTINCT recipientsProviderClassName FROM Notification WHERE recipientsProviderClassName IS NOT NULL");
            throwable = null;
            try {
                while (rs.next()) {
                    String recipientsProviderClassName = rs.getString(1);
                    OUT.write("INSERT INTO Implementation(id,type,engine,body) VALUES('" + recipientsProviderClassName + "','RECIPIENTS_PROVIDER','JAVA','" + recipientsProviderClassName + "');\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var2_2 = throwable4;
            throw throwable4;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable5) {
                        var2_2.addSuppressed(throwable5);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        OUT.write("UPDATE Notification SET recipientsProvider_id=recipientsProviderClassName;\n");
        OUT.write("ALTER TABLE Notification DROP COLUMN recipientsProviderClassName;\n");
        OUT.write("UPDATE SyncopeRole SET anyLayout=consoleLayoutInfo;\n");
        OUT.write("ALTER TABLE SyncopeRole DROP COLUMN consoleLayoutInfo;\n");
    }

    private static void upgradeFlowableTo212(Connection conn) throws IOException, SQLException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT id,workflowId FROM SyncopeUser");){
            while (rs.next()) {
                OUT.write("UPDATE ACT_RU_EXECUTION SET BUSINESS_KEY_='userWorkflow:" + rs.getString(1) + "' WHERE ID_='" + rs.getString(2) + "';\n");
            }
        }
        OUT.write("DROP VIEW user_search;\n");
        OUT.write("ALTER TABLE SyncopeUser DROP COLUMN workflowId;\n");
        OUT.write("CREATE VIEW user_search AS SELECT u.id as any_id, u.* FROM SyncopeUser u;\n");
        OUT.write("DROP VIEW group_search;\n");
        OUT.write("ALTER TABLE SyncopeGroup DROP COLUMN workflowId;\n");
        OUT.write("CREATE VIEW group_search AS SELECT r.id as any_id, r.* FROM SyncopeGroup r;\n");
        OUT.write("DROP VIEW anyObject_search;\n");
        OUT.write("ALTER TABLE AnyObject DROP COLUMN workflowId;\n");
        OUT.write("CREATE VIEW anyObject_search AS SELECT a.id as any_id, a.* FROM AnyObject a;\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 5 || args.length > 7) {
            System.err.println("Unexpected arguments: " + Arrays.asList(args));
            System.out.println("Usage: <driverClassName> <jdbcURL> <username> <password><h2|mariadb|mysql|oracle|postgres|sqlserver> [-flowable-2.1.2] [filename]");
            System.exit(1);
        }
        String driverClassName = args[0];
        String jdbcURL = args[1];
        String username = args[2];
        String password = args[3];
        String dbDictionary = args[4];
        boolean flowableTo212 = false;
        if (args.length >= 6 && !(flowableTo212 = "-flowable-2.1.2".equals(args[5]))) {
            GenerateUpgradeSQL.setWriter(new FileWriter(args[args.length - 1]));
        }
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        dataSource.setConnectionDriverName(driverClassName);
        dataSource.setConnectionURL(jdbcURL);
        dataSource.setConnectionUserName(username);
        dataSource.setConnectionPassword(password);
        try {
            JDBCConfigurationImpl jdbcConf = new JDBCConfigurationImpl();
            jdbcConf.setConnection2DriverName(driverClassName);
            jdbcConf.setConnection2UserName(username);
            jdbcConf.setConnection2Password(password);
            jdbcConf.setDBDictionary(dbDictionary);
            jdbcConf.setConnectionFactory2((Object)dataSource);
            FileSchemaFactory schemaFactory = new FileSchemaFactory();
            schemaFactory.setConfiguration((Configuration)jdbcConf);
            schemaFactory.setFile("schema.xml");
            jdbcConf.setSchemaFactory((SchemaFactory)schemaFactory);
            WiserSchemaTool schemaTool = new WiserSchemaTool((JDBCConfiguration)jdbcConf, "add");
            schemaTool.setSchemaGroup(schemaFactory.readSchema());
            schemaTool.setWriter(OUT);
            Connection conn = jdbcConf.getDataSource2(null).getConnection();
            if (flowableTo212) {
                GenerateUpgradeSQL.upgradeFlowableTo212(conn);
            } else {
                schemaTool.run();
                GenerateUpgradeSQL.upgrade(conn);
            }
        }
        finally {
            OUT.flush();
            OUT.close();
        }
    }

    private GenerateUpgradeSQL() {
    }
}

