/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDetails
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDetails.class);
    private static final String COUNT_HELP_MESSAGE = "user --details";
    private final Input input;

    public UserDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                List<UserTO> users = this.userSyncopeOperations.list();
                int withoutResource = 0;
                int withoutRole = 0;
                int activeStatus = 0;
                int suspendedStatus = 0;
                for (UserTO userTO : users) {
                    if (userTO.getResources().isEmpty()) {
                        ++withoutResource;
                    }
                    if (userTO.getRoles().isEmpty()) {
                        ++withoutRole;
                    }
                    if ("active".equalsIgnoreCase(userTO.getStatus())) {
                        ++activeStatus;
                        continue;
                    }
                    if (!"suspended".equalsIgnoreCase(userTO.getStatus())) continue;
                    ++suspendedStatus;
                }
                details.put("Total number", String.valueOf(users.size()));
                details.put("Active", String.valueOf(activeStatus));
                details.put("Suspended", String.valueOf(suspendedStatus));
                details.put("Without resources", String.valueOf(withoutResource));
                details.put("Without roles", String.valueOf(withoutRole));
                this.userResultManager.printDetails(details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about user", (Throwable)ex);
                this.userResultManager.genericError(ex.getMessage());
            }
        } else {
            this.userResultManager.unnecessaryParameters(this.input.listParameters(), COUNT_HELP_MESSAGE);
        }
    }
}

