/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.group.AbstractGroupCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupReadAttributesBySchemaType
extends AbstractGroupCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GroupReadAttributesBySchemaType.class);
    private static final String READ_HELP_MESSAGE = "group --read-attr-by-schema-type {GROUP-KEY} {SCHEMA-TYPE}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public GroupReadAttributesBySchemaType(Input input) {
        this.input = input;
    }

    public void read() {
        block7: {
            if (this.input.parameterNumber() == 2) {
                try {
                    this.groupResultManager.printAttributes(this.groupSyncopeOperations.readAttributes(this.input.firstParameter(), this.input.secondParameter()));
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error reading group", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.groupResultManager.notFoundError("Group", this.input.firstParameter());
                        break block7;
                    }
                    this.groupResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.groupResultManager.numberFormatException("group", this.input.firstParameter());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error reading schema", (Throwable)ex);
                    this.groupResultManager.typeNotValidError("schema", this.input.secondParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
                }
            } else {
                this.groupResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

