/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.anyobject;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.anyobject.AbstractAnyObjectCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyObjectReadAttributeBySchemaTypeAndSchemaKey
extends AbstractAnyObjectCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AnyObjectReadAttributeBySchemaTypeAndSchemaKey.class);
    private static final String READ_HELP_MESSAGE = "any --read-attr-by-schema {ANY_OBJECT-KEY} {SCHEMA-TYPE} {SCHEMA-KEY}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public AnyObjectReadAttributeBySchemaTypeAndSchemaKey(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() == 3) {
            try {
                this.anyResultManager.printAttribute(this.anySyncopeOperations.readAttribute(this.input.firstParameter(), this.input.secondParameter(), this.input.thirdParameter()));
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading any object", (Throwable)ex);
                this.anyResultManager.genericError(ex.getMessage());
            }
            catch (NumberFormatException ex) {
                this.anyResultManager.numberFormatException("any object", this.input.firstParameter());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error reading schema", (Throwable)ex);
                this.anyResultManager.typeNotValidError("schema", this.input.secondParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
            }
        } else {
            this.anyResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

