/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.UserRequestFormModal;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.UserRequestRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.widgets.UserRequestFormsWidget;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class UserRequestFormDirectoryPanel
extends DirectoryPanel<UserRequestForm, UserRequestForm, UserRequestFormProvider, UserRequestRestClient> {
    private static final long serialVersionUID = -7122136682275797903L;
    private static final String PREF_USER_REQUEST_FORM_PAGINATOR_ROWS = "userrequestform.paginator.rows";
    protected final BaseModal<UserRequestForm> manageFormModal = new BaseModal<UserRequestForm>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.addSubmitButton();
            this.size(Modal.Size.Large);
        }
    };

    public UserRequestFormDirectoryPanel(String id, PageReference pageReference) {
        super(id, pageReference, true);
        this.disableCheckBoxes();
        this.setFooterVisibility(false);
        this.modal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.manageFormModal});
        this.manageFormModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                UserRequestFormDirectoryPanel.this.updateResultTable(target);
                Serializable widget = SyncopeConsoleSession.get().getAttribute(UserRequestFormsWidget.class.getName());
                if (widget instanceof UserRequestFormsWidget) {
                    ((UserRequestFormsWidget)((Object)widget)).refreshLatestAlerts(target);
                }
                UserRequestFormDirectoryPanel.this.manageFormModal.show(false);
            }
        });
        this.restClient = new UserRequestRestClient();
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"USER_REQUEST_FORM_SUBMIT");
    }

    protected List<IColumn<UserRequestForm, String>> getColumns() {
        ArrayList<IColumn<UserRequestForm, String>> columns = new ArrayList<IColumn<UserRequestForm, String>>();
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("bpmnProcess"), (Object)"bpmnProcess", "bpmnProcess"));
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"formKey", "formKey"));
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("username"), "username"));
        columns.add((IColumn<UserRequestForm, String>)new DatePropertyColumn((IModel)new ResourceModel("createTime"), "createTime", "createTime"));
        columns.add((IColumn<UserRequestForm, String>)new DatePropertyColumn((IModel)new ResourceModel("dueDate"), "dueDate", "dueDate"));
        columns.add((IColumn<UserRequestForm, String>)new PropertyColumn((IModel)new ResourceModel("assignee"), (Object)"assignee", "assignee"));
        return columns;
    }

    public ActionsPanel<UserRequestForm> getActions(final IModel<UserRequestForm> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                UserRequestFormDirectoryPanel.this.claimForm(((UserRequestForm)model.getObject()).getTaskId());
                SyncopeConsoleSession.get().success((Serializable)((Object)UserRequestFormDirectoryPanel.this.getString("operation_succeeded")));
                ((BasePage)UserRequestFormDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                target.add(new Component[]{UserRequestFormDirectoryPanel.this.container});
            }
        }, ActionLink.ActionType.CLAIM, "USER_REQUEST_FORM_CLAIM");
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -4496313424398213416L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                UserRequestFormDirectoryPanel.this.unclaimForm(((UserRequestForm)model.getObject()).getTaskId());
                SyncopeConsoleSession.get().success((Serializable)((Object)UserRequestFormDirectoryPanel.this.getString("operation_succeeded")));
                UserRequestFormDirectoryPanel.this.getTogglePanel().close(target);
                target.add(new Component[]{UserRequestFormDirectoryPanel.this.container});
                ((BasePage)UserRequestFormDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected boolean statusCondition(UserRequestForm modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((UserRequestForm)model.getObject()).getAssignee());
            }
        }, ActionLink.ActionType.UNCLAIM, "USER_REQUEST_FORM_UNCLAIM");
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                UserRequestFormDirectoryPanel.this.manageFormModal.setFormModel((IModel)new CompoundPropertyModel(model.getObject()));
                target.add(new Component[]{UserRequestFormDirectoryPanel.this.manageFormModal.setContent((ModalPanel)new UserRequestFormModal(UserRequestFormDirectoryPanel.this.manageFormModal, UserRequestFormDirectoryPanel.this.pageRef, (UserRequestForm)model.getObject()){
                    private static final long serialVersionUID = 5546519445061007248L;

                    @Override
                    public void onSubmit(AjaxRequestTarget target) {
                        try {
                            super.onSubmit(target);
                            UserRequestFormDirectoryPanel.this.getTogglePanel().close(target);
                        }
                        catch (SyncopeClientException e) {
                            SyncopeConsoleSession.get().onException((Exception)((Object)e));
                        }
                        ((BasePage)UserRequestFormDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                UserRequestFormDirectoryPanel.this.manageFormModal.header((IModel)new Model((Serializable)((Object)UserRequestFormDirectoryPanel.this.getString("form.manage", (IModel)new Model((Serializable)model.getObject())))));
                UserRequestFormDirectoryPanel.this.manageFormModal.show(true);
            }

            protected boolean statusCondition(UserRequestForm modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((UserRequestForm)model.getObject()).getAssignee());
            }
        }, ActionLink.ActionType.MANAGE_APPROVAL, "USER_REQUEST_FORM_SUBMIT");
        panel.add((ActionLink)new ActionLink<UserRequestForm>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequestForm ignore) {
                UserTO previousUserTO;
                UserTO newUserTO;
                UserRequestFormDirectoryPanel.this.modal.setFormModel((IModel)new CompoundPropertyModel(model.getObject()));
                UserRequestForm formTO = (UserRequestForm)model.getObject();
                if (formTO.getUserPatch() == null) {
                    newUserTO = formTO.getUserTO();
                    previousUserTO = null;
                } else if (formTO.getUserTO() == null) {
                    previousUserTO = new UserTO();
                    previousUserTO.setKey(formTO.getUserPatch().getKey());
                    newUserTO = AnyOperations.patch((UserTO)previousUserTO, (UserPatch)formTO.getUserPatch());
                } else {
                    previousUserTO = formTO.getUserTO();
                    formTO.getUserTO().setKey(formTO.getUserPatch().getKey());
                    formTO.getUserTO().setPassword(null);
                    newUserTO = AnyOperations.patch((UserTO)formTO.getUserTO(), (UserPatch)formTO.getUserPatch());
                }
                AjaxWizard.EditItemActionEvent editItemActionEvent = new AjaxWizard.EditItemActionEvent((Serializable)newUserTO, target);
                editItemActionEvent.forceModalPanel((WizardModalPanel)new FormUserWizardBuilder((UserRequestForm)model.getObject(), previousUserTO, newUserTO, new AnyTypeRestClient().read(AnyTypeKind.USER.name()).getClasses(), AnyLayoutUtils.fetch(Collections.singletonList(AnyTypeKind.USER.name())).getUser(), UserRequestFormDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.EDIT));
                UserRequestFormDirectoryPanel.this.send((IEventSink)UserRequestFormDirectoryPanel.this, Broadcast.EXACT, editItemActionEvent);
            }

            protected boolean statusCondition(UserRequestForm modelObject) {
                return SyncopeConsoleSession.get().getSelfTO().getUsername().equals(((UserRequestForm)model.getObject()).getAssignee());
            }
        }, ActionLink.ActionType.EDIT_APPROVAL, "USER_REQUEST_FORM_SUBMIT");
        return panel;
    }

    protected UserRequestFormProvider dataProvider() {
        return new UserRequestFormProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_USER_REQUEST_FORM_PAGINATOR_ROWS;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    private void claimForm(String taskId) {
        try {
            ((UserRequestRestClient)this.restClient).claimForm(taskId);
        }
        catch (SyncopeClientException e) {
            SyncopeConsoleSession.get().onException((Exception)((Object)e));
        }
    }

    private void unclaimForm(String taskId) {
        try {
            ((UserRequestRestClient)this.restClient).unclaimForm(taskId);
        }
        catch (SyncopeClientException e) {
            SyncopeConsoleSession.get().onException((Exception)((Object)e));
        }
    }

    private class FormUserWizardBuilder
    extends UserWizardBuilder {
        private static final long serialVersionUID = 1854981134836384069L;
        private final UserRequestForm formTO;

        FormUserWizardBuilder(UserRequestForm formTO, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousUserTO, userTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.formTO = formTO;
        }

        protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
            ProvisioningResult result;
            UserTO inner = (UserTO)modelObject.getInnerObject();
            UserPatch patch = AnyOperations.diff((UserTO)inner, (UserTO)this.formTO.getUserTO(), (boolean)false);
            if (StringUtils.isNotBlank((CharSequence)inner.getPassword())) {
                PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(true).resources((Collection)inner.getResources()).build();
                patch.setPassword(passwordPatch);
            }
            if (patch.isEmpty()) {
                result = new ProvisioningResult();
                result.setEntity((EntityTO)inner);
            } else {
                result = this.userRestClient.update(((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()).getETagValue(), patch);
                ((UserRequestRestClient)UserRequestFormDirectoryPanel.this.restClient).getForm(((UserTO)result.getEntity()).getKey()).ifPresent(form -> UserRequestFormDirectoryPanel.this.claimForm(form.getTaskId()));
            }
            return result;
        }
    }

    protected static class UserRequestFormProvider
    extends DirectoryDataProvider<UserRequestForm> {
        private static final long serialVersionUID = -2311716167583335852L;
        private final UserRequestRestClient restClient = new UserRequestRestClient();

        public UserRequestFormProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("createTime", SortOrder.ASCENDING);
        }

        public Iterator<UserRequestForm> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return this.restClient.getForms((page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return this.restClient.countForms();
        }

        public IModel<UserRequestForm> model(final UserRequestForm form) {
            return new IModel<UserRequestForm>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public UserRequestForm getObject() {
                    return form;
                }
            };
        }
    }
}

