/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.servicenow;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.servicenow.SNConnectorConfiguration;
import net.tirasa.connid.bundles.servicenow.dto.PagedResults;
import net.tirasa.connid.bundles.servicenow.dto.Resource;
import net.tirasa.connid.bundles.servicenow.service.SNClient;
import net.tirasa.connid.bundles.servicenow.service.SNService;
import net.tirasa.connid.bundles.servicenow.utils.SNAttributes;
import net.tirasa.connid.bundles.servicenow.utils.SNUtils;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="ServiceNowConnector.connector.display", configurationClass=SNConnectorConfiguration.class)
public class SNConnector
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<Filter>,
TestOp,
UpdateOp {
    private SNConnectorConfiguration configuration;
    private Schema schema;
    private SNClient client;
    private static final Log LOG = Log.getLog(SNConnector.class);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        LOG.ok("Init", new Object[0]);
        this.configuration = (SNConnectorConfiguration)configuration;
        this.configuration.validate();
        this.client = new SNClient(this.configuration);
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        LOG.ok("Configuration cleanup", new Object[0]);
        this.configuration = null;
    }

    public void test() {
        LOG.ok("Connector TEST", new Object[0]);
        if (this.configuration != null) {
            if (this.client != null && this.client.testService()) {
                LOG.ok("Test was successfull", new Object[0]);
            } else {
                SNUtils.handleGeneralError("Test error. Problems with client service");
            }
        } else {
            LOG.error("Test error. No instance of the configuration class", new Object[0]);
        }
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SNAttributes.buildSchema();
        }
        return this.schema;
    }

    public FilterTranslator<Filter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return new FilterTranslator<Filter>(){

            public List<Filter> translate(Filter filter) {
                return Collections.singletonList(filter);
            }
        };
    }

    public void executeQuery(ObjectClass objectClass, Filter query, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector READ", new Object[0]);
        Attribute key = null;
        if (query instanceof EqualsFilter) {
            Attribute filterAttr = ((EqualsFilter)query).getAttribute();
            if (filterAttr instanceof Uid) {
                key = filterAttr;
            } else if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
                key = filterAttr;
            }
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        SNService.ResourceTable type = this.setResourceType(objectClass);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
            if (key == null) {
                List<Resource> resources = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() == null ? -1 : options.getPageSize();
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        PagedResults<Resource> pagedResult;
                        if (StringUtil.isNotBlank((String)cookie)) {
                            pagedResult = this.client.getResources(type, Integer.valueOf(cookie), pagesSize, false);
                            resources = pagedResult.getResult();
                            cookie = resources.size() >= pagesSize ? String.valueOf(Integer.valueOf(cookie) + resources.size()) : null;
                        } else {
                            pagedResult = this.client.getResources(type, 0, pagesSize, false);
                            resources = pagedResult.getResult();
                            cookie = String.valueOf(resources.size());
                        }
                    } else {
                        resources = this.client.getResources(type).getResult();
                    }
                }
                catch (Exception e) {
                    SNUtils.wrapGeneralError("While getting Resources!", e);
                }
                for (Resource resource : resources) {
                    handler.handle(this.fromResource(resource, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                Resource result = null;
                if (Uid.NAME.equals(key.getName()) || "sys_id".equals(key.getName())) {
                    try {
                        result = this.client.getResource(type, AttributeUtil.getAsStringValue((Attribute)key));
                    }
                    catch (Exception e) {
                        SNUtils.wrapGeneralError("While getting Resource : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                } else if (Name.NAME.equals(key.getName())) {
                    try {
                        List<Resource> resources = this.client.getResources(type, "name=" + AttributeUtil.getAsStringValue((Attribute)key) + "").getResult();
                        if (resources.isEmpty() && type.equals((Object)SNService.ResourceTable.sys_user)) {
                            resources = this.client.getResources(type, "user_name=" + AttributeUtil.getAsStringValue((Attribute)key)).getResult();
                        }
                        if (!resources.isEmpty()) {
                            result = resources.get(0);
                        }
                    }
                    catch (Exception e) {
                        SNUtils.wrapGeneralError("While getting Resource : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                }
                if (result != null) {
                    handler.handle(this.fromResource(result, attributesToGet));
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (createAttributes == null || createAttributes.isEmpty()) {
            SNUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        SNService.ResourceTable type = this.setResourceType(objectClass);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
            Resource resource = new Resource();
            String username = accessor.findString("user_name");
            String name = accessor.findString("name");
            if (StringUtil.isBlank((String)username) && StringUtil.isBlank((String)name)) {
                name = accessor.findString(Name.NAME);
            }
            GuardedString password = accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            try {
                resource.setName(name);
                resource.setUserName(username);
                if (password == null) {
                    LOG.ok("No password attribute", new Object[0]);
                } else {
                    resource.setUserPassword(SecurityUtil.decrypt((GuardedString)password));
                }
                if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                    LOG.warn("{0} attribute value not correct or not found, won't handle Resource status", new Object[]{OperationalAttributes.ENABLE_NAME});
                } else {
                    resource.setActive(status.getValue().get(0).toString());
                }
                resource.fromAttributes(createAttributes);
                this.client.createResource(type, resource);
            }
            catch (Exception e) {
                SNUtils.wrapGeneralError("Could not create Resource : " + username, e);
            }
            return new Uid(resource.getSysId());
        }
        LOG.warn("Create of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided {0} ", new Object[]{objectClass});
            throw new InvalidAttributeValueException("Object value not provided");
        }
        SNService.ResourceTable type = this.setResourceType(objectClass);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                this.client.deleteResource(type, uid.getUidValue());
            }
            catch (Exception e) {
                SNUtils.wrapGeneralError("Could not delete Resource " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            SNUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        SNService.ResourceTable type = this.setResourceType(objectClass);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
            Uid returnUid = uid;
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            String username = accessor.findString("user_name");
            String name = accessor.findString("name");
            if (StringUtil.isBlank((String)username) && StringUtil.isBlank((String)name)) {
                name = accessor.findString(Name.NAME);
            }
            Resource resource = new Resource();
            resource.setSysId(uid.getUidValue());
            resource.setUserName(username);
            resource.setUserName(name);
            if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                LOG.warn("{0} attribute value not correct, can't handle Resource  status update", new Object[]{OperationalAttributes.ENABLE_NAME});
            } else {
                resource.setActive(status.getValue().get(0).toString());
            }
            try {
                GuardedString password;
                resource.fromAttributes(replaceAttributes);
                GuardedString guardedString = password = accessor.getPassword() != null ? accessor.getPassword() : accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
                if (password == null) {
                    LOG.ok("No password attribute", new Object[0]);
                } else {
                    String decryptedPassword = SecurityUtil.decrypt((GuardedString)password);
                    resource.setUserPassword(decryptedPassword);
                }
                this.client.updateResource(type, resource);
                returnUid = new Uid(resource.getSysId());
            }
            catch (Exception e) {
                SNUtils.wrapGeneralError("Could not update Resource " + uid.getUidValue() + " from attributes ", e);
            }
            return returnUid;
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public SNClient getClient() {
        return this.client;
    }

    private ConnectorObject fromResource(Resource resource, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(resource.getSysId());
        builder.setName(StringUtil.isBlank((String)resource.getUserName()) ? resource.getName() : resource.getUserName());
        try {
            Set<Attribute> attributes = resource.toAttributes();
            block2: for (Attribute toAttribute : attributes) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        return builder.build();
    }

    private SNService.ResourceTable setResourceType(ObjectClass objectClass) {
        SNService.ResourceTable type = null;
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            type = SNService.ResourceTable.sys_user;
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            type = SNService.ResourceTable.sys_user_group;
        }
        return type;
    }
}

