/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskBuilder;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryType;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.TaskQueryImpl;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.flowable.task.service.impl.persistence.entity.data.TaskDataManager;
import org.flowable.task.service.impl.util.CommandContextUtil;

public class TaskEntityManagerImpl
extends AbstractEntityManager<TaskEntity>
implements TaskEntityManager {
    protected TaskDataManager taskDataManager;

    public TaskEntityManagerImpl(TaskServiceConfiguration taskServiceConfiguration, TaskDataManager taskDataManager) {
        super(taskServiceConfiguration);
        this.taskDataManager = taskDataManager;
    }

    @Override
    protected DataManager<TaskEntity> getDataManager() {
        return this.taskDataManager;
    }

    @Override
    public TaskEntity create() {
        TaskEntity taskEntity = (TaskEntity)super.create();
        taskEntity.setCreateTime(this.getClock().getCurrentTime());
        if (this.taskServiceConfiguration.isEnableTaskRelationshipCounts()) {
            ((CountingTaskEntity)((Object)taskEntity)).setCountEnabled(true);
        }
        return taskEntity;
    }

    @Override
    public TaskEntity createTask(TaskBuilder taskBuilder) {
        TaskEntity taskEntity = this.create();
        taskEntity.setId(taskBuilder.getId());
        taskEntity.setName(taskBuilder.getName());
        taskEntity.setDescription(taskBuilder.getDescription());
        taskEntity.setPriority(taskBuilder.getPriority());
        taskEntity.setOwner(taskBuilder.getOwner());
        taskEntity.setAssignee(taskBuilder.getAssignee());
        taskEntity.setDueDate(taskBuilder.getDueDate());
        taskEntity.setCategory(taskBuilder.getCategory());
        taskEntity.setParentTaskId(taskBuilder.getParentTaskId());
        taskEntity.setTenantId(taskBuilder.getTenantId());
        taskEntity.setFormKey(taskBuilder.getFormKey());
        taskEntity.setTaskDefinitionId(taskBuilder.getTaskDefinitionId());
        taskEntity.setTaskDefinitionKey(taskBuilder.getTaskDefinitionKey());
        taskEntity.setScopeId(taskBuilder.getScopeId());
        taskEntity.setScopeType(taskBuilder.getScopeType());
        this.insert(taskEntity);
        TaskEntity enrichedTaskEntity = this.taskServiceConfiguration.getTaskPostProcessor().enrich(taskEntity);
        this.update(enrichedTaskEntity, false);
        taskBuilder.getIdentityLinks().forEach(identityLink -> {
            if (identityLink.getGroupId() != null) {
                enrichedTaskEntity.addGroupIdentityLink(identityLink.getGroupId(), identityLink.getType());
            } else if (identityLink.getUserId() != null) {
                enrichedTaskEntity.addUserIdentityLink(identityLink.getUserId(), identityLink.getType());
            }
        });
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled() && taskEntity.getAssignee() != null) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity));
        }
        this.taskServiceConfiguration.getInternalHistoryTaskManager().recordTaskCreated(taskEntity);
        return enrichedTaskEntity;
    }

    @Override
    public void insert(TaskEntity taskEntity, boolean fireCreatedEvent) {
        super.insert(taskEntity, fireCreatedEvent);
        if (fireCreatedEvent) {
            this.logTaskCreatedEvent((TaskInfo)taskEntity);
        }
    }

    @Override
    public TaskEntity update(TaskEntity taskEntity, boolean fireUpdateEvents) {
        if (fireUpdateEvents) {
            this.logTaskUpdateEvents(taskEntity);
        }
        return super.update(taskEntity, fireUpdateEvents);
    }

    protected IdentityLinkService getIdentityLinkService() {
        return CommandContextUtil.getIdentityLinkServiceConfiguration().getIdentityLinkService();
    }

    @Override
    public void changeTaskAssignee(TaskEntity taskEntity, String assignee) {
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().equals(assignee) || taskEntity.getAssignee() == null && assignee != null) {
            taskEntity.setAssignee(assignee);
            if (taskEntity.getId() != null) {
                this.getTaskServiceConfiguration().getInternalHistoryTaskManager().recordTaskInfoChange(taskEntity, this.getClock().getCurrentTime());
                this.update(taskEntity);
            }
        }
    }

    @Override
    public void changeTaskOwner(TaskEntity taskEntity, String owner) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(owner) || taskEntity.getOwner() == null && owner != null) {
            taskEntity.setOwner(owner);
            if (taskEntity.getId() != null) {
                this.getTaskServiceConfiguration().getInternalHistoryTaskManager().recordTaskInfoChange(taskEntity, this.getClock().getCurrentTime());
                this.update(taskEntity);
            }
        }
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.taskDataManager.findTasksByExecutionId(executionId);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.taskDataManager.findTasksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<TaskEntity> findTasksByScopeIdAndScopeType(String scopeId, String scopeType) {
        return this.taskDataManager.findTasksByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public List<TaskEntity> findTasksBySubScopeIdAndScopeType(String subScopeId, String scopeType) {
        return this.taskDataManager.findTasksBySubScopeIdAndScopeType(subScopeId, scopeType);
    }

    @Override
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        return this.taskDataManager.findTasksByQueryCriteria(taskQuery);
    }

    @Override
    public List<Task> findTasksWithRelatedEntitiesByQueryCriteria(TaskQueryImpl taskQuery) {
        return this.taskDataManager.findTasksWithRelatedEntitiesByQueryCriteria(taskQuery);
    }

    @Override
    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return this.taskDataManager.findTaskCountByQueryCriteria(taskQuery);
    }

    @Override
    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap) {
        return this.taskDataManager.findTasksByNativeQuery(parameterMap);
    }

    @Override
    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.taskDataManager.findTaskCountByNativeQuery(parameterMap);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.taskDataManager.findTasksByParentTaskId(parentTaskId);
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.taskDataManager.updateTaskTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void updateAllTaskRelatedEntityCountFlags(boolean configProperty) {
        this.taskDataManager.updateAllTaskRelatedEntityCountFlags(configProperty);
    }

    @Override
    public void deleteTasksByExecutionId(String executionId) {
        this.taskDataManager.deleteTasksByExecutionId(executionId);
    }

    public TaskDataManager getTaskDataManager() {
        return this.taskDataManager;
    }

    public void setTaskDataManager(TaskDataManager taskDataManager) {
        this.taskDataManager = taskDataManager;
    }

    protected void logAssigneeChanged(TaskEntity taskEntity, String previousAssignee, String newAssignee) {
        if (this.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = this.taskServiceConfiguration.getObjectMapper().createObjectNode();
            dataNode.put("newAssigneeId", newAssignee);
            dataNode.put("previousAssigneeId", previousAssignee);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_ASSIGNEE_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logOwnerChanged(TaskEntity taskEntity, String previousOwner, String newOwner) {
        if (this.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = this.taskServiceConfiguration.getObjectMapper().createObjectNode();
            dataNode.put("newOwnerId", newOwner);
            dataNode.put("previousOwnerId", previousOwner);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_OWNER_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logPriorityChanged(TaskEntity taskEntity, Integer previousPriority, int newPriority) {
        if (this.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = this.taskServiceConfiguration.getObjectMapper().createObjectNode();
            dataNode.put("newPriority", newPriority);
            dataNode.put("previousPriority", previousPriority);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_PRIORITY_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logDueDateChanged(TaskEntity taskEntity, Date previousDueDate, Date newDueDate) {
        if (this.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = this.taskServiceConfiguration.getObjectMapper().createObjectNode();
            dataNode.put("newDueDate", newDueDate != null ? Long.valueOf(newDueDate.getTime()) : null);
            dataNode.put("previousDueDate", previousDueDate != null ? Long.valueOf(previousDueDate.getTime()) : null);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_DUEDATE_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logNameChanged(TaskEntity taskEntity, String previousName, String newName) {
        if (this.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = this.taskServiceConfiguration.getObjectMapper().createObjectNode();
            dataNode.put("newName", newName);
            dataNode.put("previousName", previousName);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_NAME_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logTaskCreatedEvent(TaskInfo task) {
        if (this.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            HistoricTaskLogEntryBuilder taskLogEntryBuilder = this.createHistoricTaskLogEntryBuilder(task, HistoricTaskLogEntryType.USER_TASK_CREATED);
            taskLogEntryBuilder.timeStamp(task.getCreateTime());
            this.getTaskServiceConfiguration().getInternalHistoryTaskManager().recordHistoryUserTaskLog(taskLogEntryBuilder);
        }
    }

    protected HistoricTaskLogEntryBuilder createHistoricTaskLogEntryBuilder(TaskInfo task, HistoricTaskLogEntryType userTaskCreated) {
        BaseHistoricTaskLogEntryBuilderImpl taskLogEntryBuilder = new BaseHistoricTaskLogEntryBuilderImpl(task);
        taskLogEntryBuilder.timeStamp(this.taskServiceConfiguration.getClock().getCurrentTime());
        taskLogEntryBuilder.userId(Authentication.getAuthenticatedUserId());
        taskLogEntryBuilder.type(userTaskCreated.name());
        return taskLogEntryBuilder;
    }

    protected void logTaskUpdateEvents(TaskEntity task) {
        if (this.wasPersisted(task)) {
            if (!Objects.equals(task.getAssignee(), this.getOriginalState(task, "assignee"))) {
                this.logAssigneeChanged(task, (String)this.getOriginalState(task, "assignee"), task.getAssignee());
            }
            if (!Objects.equals(task.getOwner(), this.getOriginalState(task, "owner"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_OWNER_CHANGED, task));
                }
                this.logOwnerChanged(task, (String)this.getOriginalState(task, "owner"), task.getOwner());
            }
            if (!Objects.equals(task.getPriority(), this.getOriginalState(task, "priority"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_PRIORITY_CHANGED, task));
                }
                this.logPriorityChanged(task, (Integer)this.getOriginalState(task, "priority"), task.getPriority());
            }
            if (!Objects.equals(task.getDueDate(), this.getOriginalState(task, "dueDate"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_DUEDATE_CHANGED, task));
                }
                this.logDueDateChanged(task, (Date)this.getOriginalState(task, "dueDate"), task.getDueDate());
            }
            if (!Objects.equals(task.getName(), this.getOriginalState(task, "name"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_NAME_CHANGED, task));
                }
                this.logNameChanged(task, (String)this.getOriginalState(task, "name"), task.getName());
            }
        }
    }

    protected boolean wasPersisted(TaskEntity task) {
        return task.getOriginalPersistentState() != null && ((Map)task.getOriginalPersistentState()).size() > 0;
    }

    protected Object getOriginalState(TaskEntity task, String stateKey) {
        if (task.getOriginalPersistentState() != null) {
            return ((Map)task.getOriginalPersistentState()).get(stateKey);
        }
        return null;
    }

    protected void recordHistoryUserTaskLog(HistoricTaskLogEntryType logEntryType, TaskInfo task, ObjectNode dataNode) {
        HistoricTaskLogEntryBuilder taskLogEntryBuilder = this.createHistoricTaskLogEntryBuilder(task, logEntryType);
        taskLogEntryBuilder.data(dataNode.toString());
        this.getTaskServiceConfiguration().getInternalHistoryTaskManager().recordHistoryUserTaskLog(taskLogEntryBuilder);
    }
}

