/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.persistence.OpenJPAEnum;

public enum ResultSetType implements OpenJPAEnum<ResultSetType>
{
    FORWARD_ONLY(1003),
    SCROLL_INSENSITIVE(1004),
    SCROLL_SENSITIVE(1005);

    private final int resultSetConstant;

    private ResultSetType(int value) {
        this.resultSetConstant = value;
    }

    public int toKernelConstant() {
        return this.resultSetConstant;
    }

    static ResultSetType fromKernelConstant(int kernelConstant) {
        switch (kernelConstant) {
            case 1003: {
                return FORWARD_ONLY;
            }
            case 1004: {
                return SCROLL_INSENSITIVE;
            }
            case 1005: {
                return SCROLL_SENSITIVE;
            }
        }
        throw new IllegalArgumentException(kernelConstant + "");
    }

    public int convertToKernelConstant(String s) {
        return ResultSetType.toKernelConstantFromString(s);
    }

    public int convertToKernelConstant(int i) {
        if (i == -99) {
            return i;
        }
        for (ResultSetType level : ResultSetType.values()) {
            if (level.resultSetConstant != i) continue;
            return i;
        }
        throw new IllegalArgumentException(i + " is invalid value for ResultSetType");
    }

    public static int toKernelConstantFromString(String s) {
        for (ResultSetType level : ResultSetType.values()) {
            if (!level.name().equalsIgnoreCase(s) && !String.valueOf(level.toKernelConstant()).equals(s)) continue;
            return level.toKernelConstant();
        }
        throw new IllegalArgumentException(s + " is not a valid name for " + ResultSetType.class.getName());
    }
}

