/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.saml2lsp.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.to.SAML2ReceivedResponseTO;
import org.apache.syncope.common.lib.to.SAML2RequestTO;
import org.apache.syncope.common.rest.api.service.SAML2SPService;
import org.apache.syncope.ext.saml2lsp.agent.AbstractSAML2SPServlet;

@WebServlet(name="logout", urlPatterns={"/saml2sp/logout"})
public class Logout
extends AbstractSAML2SPServlet {
    private static final long serialVersionUID = 3010286040376932117L;

    private void doLogout(SAML2ReceivedResponseTO receivedResponse, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SyncopeClientFactoryBean clientFactory = (SyncopeClientFactoryBean)request.getServletContext().getAttribute("SyncopeClientFactory");
        try {
            String accessToken = (String)request.getSession().getAttribute("saml2sp.jwt");
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                throw new IllegalArgumentException("No access token found ");
            }
            SyncopeClient client = clientFactory.create(accessToken);
            ((SAML2SPService)client.getService(SAML2SPService.class)).validateLogoutResponse(receivedResponse);
            String successURL = this.getServletContext().getInitParameter("saml2sp.logout.success.url");
            if (successURL == null) {
                request.getRequestDispatcher("logoutSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(successURL);
            }
            request.getSession().removeAttribute("saml2sp.jwt");
        }
        catch (Exception e) {
            LOG.error("While processing authentication response from IdP", (Throwable)e);
            String errorURL = this.getServletContext().getInitParameter("saml2sp.logout.error.url");
            if (errorURL == null) {
                request.setAttribute("exception", (Object)e);
                request.getRequestDispatcher("logoutError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                e.printStackTrace(response.getWriter());
            }
            response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            String samlResponse = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            if (samlResponse == null) {
                SyncopeClientFactoryBean clientFactory = (SyncopeClientFactoryBean)request.getServletContext().getAttribute("SyncopeClientFactory");
                try {
                    String accessToken = (String)request.getSession().getAttribute("saml2sp.jwt");
                    if (StringUtils.isBlank((CharSequence)accessToken)) {
                        throw new IllegalArgumentException("No access token found ");
                    }
                    SyncopeClient client = clientFactory.create(accessToken);
                    SAML2RequestTO requestTO = ((SAML2SPService)client.getService(SAML2SPService.class)).createLogoutRequest(StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/saml2sp"));
                    this.prepare(response, requestTO);
                }
                catch (Exception e) {
                    LOG.error("While preparing logout request to IdP", (Throwable)e);
                    String errorURL = this.getServletContext().getInitParameter("saml2sp.logout.error.url");
                    if (errorURL == null) {
                        request.setAttribute("exception", (Object)e);
                        request.getRequestDispatcher("logoutError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                        e.printStackTrace(response.getWriter());
                        break block6;
                    }
                    response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
                }
            } else {
                SAML2ReceivedResponseTO receivedResponse = new SAML2ReceivedResponseTO();
                receivedResponse.setSamlResponse(samlResponse);
                receivedResponse.setRelayState(relayState);
                this.doLogout(receivedResponse, request, response);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SAML2ReceivedResponseTO receivedResponse = this.extract(StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/saml2sp"), "saml2sp", request.getRemoteAddr(), (InputStream)request.getInputStream());
        this.doLogout(receivedResponse, request, response);
    }
}

