/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.annotations.ExtWidget;
import org.apache.syncope.client.console.chartjs.Bar;
import org.apache.syncope.client.console.chartjs.BarDataSet;
import org.apache.syncope.client.console.chartjs.ChartJSPanel;
import org.apache.syncope.client.console.rest.CamelRoutesRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.syncope.common.lib.to.CamelMetrics;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Duration;

@ExtWidget(cssClass="col-md-6")
public class CamelMetricsWidget
extends BaseExtWidget {
    private static final long serialVersionUID = 4157815058487313617L;
    private List<CamelMetrics.MeanRate> meanRates;
    private final ChartJSPanel chart;
    private final CamelRoutesRestClient restClient = new CamelRoutesRestClient();

    public CamelMetricsWidget(String id, PageReference pageRef) {
        super(id, pageRef);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        CamelMetrics metrics = this.restClient.metrics();
        this.meanRates = new ArrayList<CamelMetrics.MeanRate>(5);
        for (int i = 0; i < 5; ++i) {
            this.meanRates.add((CamelMetrics.MeanRate)metrics.getResponseMeanRates().get(i));
        }
        this.chart = new ChartJSPanel("chart", (IModel)Model.of((Serializable)this.build(this.meanRates)));
        container.add(new Component[]{this.chart});
        container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)60)){
            private static final long serialVersionUID = -4426283634345968585L;

            protected void onTimer(AjaxRequestTarget target) {
                CamelMetrics metrics = CamelMetricsWidget.this.restClient.metrics();
                ArrayList updatedMeanRates = new ArrayList(5);
                for (int i = 0; i < 5; ++i) {
                    updatedMeanRates.add(metrics.getResponseMeanRates().get(i));
                }
                if (CamelMetricsWidget.this.refresh(updatedMeanRates)) {
                    target.add(new Component[]{CamelMetricsWidget.this});
                }
            }
        }});
    }

    private Bar build(List<CamelMetrics.MeanRate> meanRates) {
        Bar bar = new Bar();
        bar.getOptions().setScaleBeginAtZero(Boolean.valueOf(true));
        bar.getOptions().setBarShowStroke(Boolean.valueOf(true));
        bar.getOptions().setBarStrokeWidth(Integer.valueOf(2));
        bar.getOptions().setBarValueSpacing(Integer.valueOf(5));
        bar.getOptions().setBarDatasetSpacing(Integer.valueOf(1));
        bar.getOptions().setResponsive(true);
        bar.getOptions().setMaintainAspectRatio(Boolean.valueOf(true));
        bar.getData().getLabels().addAll(meanRates.stream().map(input -> input.getRouteId()).collect(Collectors.toList()));
        BarDataSet dataset = new BarDataSet(meanRates.stream().map(input -> input.getValue()).collect(Collectors.toList()));
        dataset.setFillColor("blue");
        bar.getData().getDatasets().add(dataset);
        return bar;
    }

    private boolean refresh(List<CamelMetrics.MeanRate> meanRates) {
        if (!this.meanRates.equals(meanRates)) {
            this.meanRates = meanRates;
            this.chart.setDefaultModelObject((Object)this.build(meanRates));
            return true;
        }
        return false;
    }
}

