/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.SAML2IdPsRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;

public class ImportMetadata
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = 6959177759869415782L;
    private final SAML2IdPsRestClient restClient = new SAML2IdPsRestClient();
    private final Form<?> form = new Form("metadataForm");

    public ImportMetadata(String id, final WebMarkupContainer container, final PageReference pageRef) {
        super(id, pageRef);
        this.addInnerObject(new Component[]{this.form});
        final Model metadata = new Model();
        FileInputConfig config = new FileInputConfig();
        config.showUpload(false);
        config.showRemove(false);
        config.showPreview(false);
        final BootstrapFileInputField fileUpload = new BootstrapFileInputField("fileUpload", (IModel)new ListModel(new ArrayList()), config);
        fileUpload.setOutputMarkupId(true);
        fileUpload.add(new Behavior[]{new AjaxFormSubmitBehavior("change"){
            private static final long serialVersionUID = 5538299138211283825L;

            protected void onSubmit(AjaxRequestTarget target) {
                FileUpload uploadedFile = fileUpload.getFileUpload();
                if (uploadedFile != null) {
                    metadata.setObject((Serializable)uploadedFile.getBytes());
                }
            }
        }});
        this.form.add(new Component[]{fileUpload});
        this.form.add(new Component[]{new AjaxSubmitLink("doUpload", this.form){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (ArrayUtils.isNotEmpty((byte[])((byte[])metadata.getObject()))) {
                    try {
                        ImportMetadata.this.restClient.importIdPs(new ByteArrayInputStream((byte[])metadata.getObject()));
                        metadata.setObject(null);
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        ImportMetadata.this.toggle(target, false);
                        target.add(new Component[]{container});
                    }
                    catch (Exception e) {
                        TogglePanel.LOG.error("While importing SAML 2.0 IdP metadata", (Throwable)e);
                        SyncopeConsoleSession.get().onException(e);
                    }
                    ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }
}

