/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.HasAssociations;
import org.flowable.cmmn.model.HasEntryCriteria;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.PlanItemDefinition;

public class PlanItem
extends CaseElement
implements HasEntryCriteria,
HasExitCriteria,
HasAssociations {
    protected String definitionRef;
    protected PlanItemDefinition planItemDefinition;
    protected PlanItemControl itemControl;
    protected Set<String> criteriaRefs = new HashSet<String>();
    protected List<Criterion> entryCriteria = new ArrayList<Criterion>();
    protected List<Criterion> exitCriteria = new ArrayList<Criterion>();
    protected List<Association> incomingAssociations = new ArrayList<Association>();
    protected List<Association> outgoingAssociations = new ArrayList<Association>();
    protected List<PlanItem> entryDependencies = new ArrayList<PlanItem>();
    protected List<PlanItem> exitDependencies = new ArrayList<PlanItem>();
    protected List<PlanItem> entryDependentPlanItems = new ArrayList<PlanItem>();
    protected List<PlanItem> exitDependentPlanItems = new ArrayList<PlanItem>();
    protected Object behavior;

    public String getDefinitionRef() {
        return this.definitionRef;
    }

    public void setDefinitionRef(String definitionRef) {
        this.definitionRef = definitionRef;
    }

    public PlanItemDefinition getPlanItemDefinition() {
        return this.planItemDefinition;
    }

    public void setPlanItemDefinition(PlanItemDefinition planItemDefinition) {
        this.planItemDefinition = planItemDefinition;
    }

    public PlanItemControl getItemControl() {
        return this.itemControl;
    }

    public void setItemControl(PlanItemControl itemControl) {
        this.itemControl = itemControl;
    }

    public void addCriteriaRef(String entryCriteriaRef) {
        this.criteriaRefs.add(entryCriteriaRef);
    }

    public Set<String> getCriteriaRefs() {
        return this.criteriaRefs;
    }

    public void setCriteriaRefs(Set<String> criteriaRefs) {
        this.criteriaRefs = criteriaRefs;
    }

    @Override
    public void addEntryCriterion(Criterion entryCriterion) {
        this.entryCriteria.add(entryCriterion);
    }

    @Override
    public List<Criterion> getEntryCriteria() {
        return this.entryCriteria;
    }

    @Override
    public void setEntryCriteria(List<Criterion> entryCriteria) {
        this.entryCriteria = entryCriteria;
    }

    @Override
    public void addExitCriterion(Criterion exitCriterion) {
        this.exitCriteria.add(exitCriterion);
    }

    @Override
    public List<Criterion> getExitCriteria() {
        return this.exitCriteria;
    }

    @Override
    public void setExitCriteria(List<Criterion> exitCriteria) {
        this.exitCriteria = exitCriteria;
    }

    @Override
    public void addIncomingAssociation(Association association) {
        this.incomingAssociations.add(association);
    }

    @Override
    public List<Association> getIncomingAssociations() {
        return this.incomingAssociations;
    }

    @Override
    public void setIncomingAssociations(List<Association> incomingAssociations) {
        this.incomingAssociations = incomingAssociations;
    }

    @Override
    public void addOutgoingAssociation(Association association) {
        this.outgoingAssociations.add(association);
    }

    @Override
    public List<Association> getOutgoingAssociations() {
        return this.outgoingAssociations;
    }

    @Override
    public void setOutgoingAssociations(List<Association> outgoingAssociations) {
        this.outgoingAssociations = outgoingAssociations;
    }

    public Object getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Object behavior) {
        this.behavior = behavior;
    }

    public List<PlanItem> getEntryDependencies() {
        return this.entryDependencies;
    }

    public void setEntryDependencies(List<PlanItem> entryDependencies) {
        this.entryDependencies = entryDependencies;
    }

    public List<PlanItem> getExitDependencies() {
        return this.exitDependencies;
    }

    public void setExitDependencies(List<PlanItem> exitDependencies) {
        this.exitDependencies = exitDependencies;
    }

    public List<PlanItem> getEntryDependentPlanItems() {
        return this.entryDependentPlanItems;
    }

    public void setEntryDependentPlanItems(List<PlanItem> entryDependentPlanItems) {
        this.entryDependentPlanItems = entryDependentPlanItems;
    }

    public void addEntryDependentPlanItem(PlanItem planItem) {
        Optional<PlanItem> planItemWithSameId = this.entryDependentPlanItems.stream().filter(p -> p.getId().equals(planItem.getId())).findFirst();
        if (!planItemWithSameId.isPresent()) {
            this.entryDependentPlanItems.add(planItem);
        }
    }

    public List<PlanItem> getExitDependentPlanItems() {
        return this.exitDependentPlanItems;
    }

    public void setExitDependentPlanItems(List<PlanItem> exitDependentPlanItems) {
        this.exitDependentPlanItems = exitDependentPlanItems;
    }

    public void addExitDependentPlanItem(PlanItem planItem) {
        Optional<PlanItem> planItemWithSameId = this.exitDependentPlanItems.stream().filter(p -> p.getId().equals(planItem.getId())).findFirst();
        if (!planItemWithSameId.isPresent()) {
            this.exitDependentPlanItems.add(planItem);
        }
    }

    public List<PlanItem> getAllDependentPlanItems() {
        ArrayList<PlanItem> allDependentPlanItems = new ArrayList<PlanItem>(this.entryDependentPlanItems.size() + this.exitDependentPlanItems.size());
        allDependentPlanItems.addAll(this.entryDependentPlanItems);
        allDependentPlanItems.addAll(this.exitDependentPlanItems);
        return allDependentPlanItems;
    }

    public String toString() {
        return "PlanItem " + this.id + (this.name != null ? " " + this.name : "");
    }
}

