/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.HistoricProcessInstanceQueryProperty;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class HistoricProcessInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricProcessInstanceQuery, HistoricProcessInstance>
implements HistoricProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String businessKey;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected boolean finished;
    protected boolean unfinished;
    protected boolean deleted;
    protected boolean notDeleted;
    protected String startedBy;
    protected String superProcessInstanceId;
    protected boolean excludeSubprocesses;
    protected List<String> processDefinitionKeyIn;
    protected List<String> processKeyNotIn;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String processDefinitionKey;
    protected String processDefinitionCategory;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected Set<String> processInstanceIds;
    protected String involvedUser;
    protected Set<String> involvedGroups;
    protected boolean includeProcessVariables;
    protected Integer processInstanceVariablesLimit;
    protected boolean withJobException;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected String callbackId;
    protected String callbackType;
    protected String locale;
    protected boolean withLocalizationFallback;
    protected List<HistoricProcessInstanceQueryImpl> orQueryObjects = new ArrayList<HistoricProcessInstanceQueryImpl>();
    protected HistoricProcessInstanceQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;

    public HistoricProcessInstanceQueryImpl() {
    }

    public HistoricProcessInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricProcessInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricProcessInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceIds(Set<String> processInstanceIds) {
        if (processInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Set of process instance ids is null");
        }
        if (processInstanceIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of process instance ids is empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceIds = processInstanceIds;
        } else {
            this.processInstanceIds = processInstanceIds;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKey(String processDefinitionKey) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKeyIn(List<String> processDefinitionKeys) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeyIn = processDefinitionKeys;
        } else {
            this.processDefinitionKeyIn = processDefinitionKeys;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionCategory(String processDefinitionCategory) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionCategory = processDefinitionCategory;
        } else {
            this.processDefinitionCategory = processDefinitionCategory;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionName(String processDefinitionName) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionName = processDefinitionName;
        } else {
            this.processDefinitionName = processDefinitionName;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionVersion(Integer processDefinitionVersion) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionVersion = processDefinitionVersion;
        } else {
            this.processDefinitionVersion = processDefinitionVersion;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceBusinessKey(String businessKey) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKey = businessKey;
        } else {
            this.businessKey = businessKey;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery deploymentId(String deploymentId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery deploymentIdIn(List<String> deploymentIds) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.finished = true;
        } else {
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery unfinished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.unfinished = true;
        } else {
            this.unfinished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery deleted() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.deleted = true;
        } else {
            this.deleted = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery notDeleted() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.notDeleted = true;
        } else {
            this.notDeleted = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBy(String startedBy) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBy = startedBy;
        } else {
            this.startedBy = startedBy;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processKeyNotIn = processDefinitionKeys;
        } else {
            this.processKeyNotIn = processDefinitionKeys;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedAfter(Date startedAfter) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedAfter = startedAfter;
        } else {
            this.startedAfter = startedAfter;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBefore(Date startedBefore) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBefore = startedBefore;
        } else {
            this.startedBefore = startedBefore;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedAfter(Date finishedAfter) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.finishedAfter = finishedAfter;
        } else {
            this.finishedAfter = finishedAfter;
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedBefore(Date finishedBefore) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.finishedBefore = finishedBefore;
        } else {
            this.finishedBefore = finishedBefore;
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery superProcessInstanceId(String superProcessInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.superProcessInstanceId = superProcessInstanceId;
        } else {
            this.superProcessInstanceId = superProcessInstanceId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery excludeSubprocesses(boolean excludeSubprocesses) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.excludeSubprocesses = excludeSubprocesses;
        } else {
            this.excludeSubprocesses = excludeSubprocesses;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery involvedUser(String involvedUser) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery involvedGroups(Set<String> involvedGroups) {
        if (involvedGroups == null) {
            throw new FlowableIllegalArgumentException("involvedGroups are null");
        }
        if (involvedGroups.isEmpty()) {
            throw new FlowableIllegalArgumentException("involvedGroups are empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroups = involvedGroups;
        } else {
            this.involvedGroups = involvedGroups;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery limitProcessInstanceVariables(Integer processInstanceVariablesLimit) {
        this.processInstanceVariablesLimit = processInstanceVariablesLimit;
        return this;
    }

    public Integer getProcessInstanceVariablesLimit() {
        return this.processInstanceVariablesLimit;
    }

    @Override
    public HistoricProcessInstanceQuery withJobException() {
        this.withJobException = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("process instance tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("process instance tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceName(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.name = name;
        } else {
            this.name = name;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceNameLike(String nameLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.nameLike = nameLike;
        } else {
            this.nameLike = nameLike;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        } else {
            this.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceCallbackId(String callbackId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackId = callbackId;
        } else {
            this.callbackId = callbackId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceCallbackType(String callbackType) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackType = callbackType;
        } else {
            this.callbackType = callbackType;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    public HistoricProcessInstanceQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLike(name, value, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableExists(name, false);
    }

    @Override
    public HistoricProcessInstanceQuery variableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableNotExists(name, false);
    }

    @Override
    public HistoricProcessInstanceQuery locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery withLocalizationFallback() {
        this.withLocalizationFallback = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = new HistoricProcessInstanceQueryImpl();
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceBusinessKey() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceDuration() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.DURATION);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceStartTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.START_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceEndTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.END_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
    }

    @Override
    public HistoricProcessInstanceQuery orderByTenantId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.TENANT_ID);
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderByColumns();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
            specialOrderBy = specialOrderBy.replace("VAR.", "TEMPVAR_");
        }
        return specialOrderBy;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (processEngineConfiguration.getHistoricProcessInstanceQueryInterceptor() != null) {
            processEngineConfiguration.getHistoricProcessInstanceQueryInterceptor().beforeHistoricProcessInstanceQueryExecute(this);
        }
        return CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext).findHistoricProcessInstanceCountByQueryCriteria(this);
    }

    public List<HistoricProcessInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<HistoricProcessInstance> results = null;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (processEngineConfiguration.getHistoricProcessInstanceQueryInterceptor() != null) {
            processEngineConfiguration.getHistoricProcessInstanceQueryInterceptor().beforeHistoricProcessInstanceQueryExecute(this);
        }
        results = this.includeProcessVariables ? CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext).findHistoricProcessInstancesAndVariablesByQueryCriteria(this) : CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext).findHistoricProcessInstancesByQueryCriteria(this);
        if (processEngineConfiguration.getPerformanceSettings().isEnableLocalization()) {
            for (HistoricProcessInstance processInstance : results) {
                this.localize(processInstance, commandContext);
            }
        }
        if (processEngineConfiguration.getHistoricProcessInstanceQueryInterceptor() != null) {
            processEngineConfiguration.getHistoricProcessInstanceQueryInterceptor().afterHistoricProcessInstanceQueryExecute(this, results);
        }
        return results;
    }

    protected void localize(HistoricProcessInstance processInstance, CommandContext commandContext) {
        ProcessDefinition processDefinition;
        ObjectNode languageNode;
        HistoricProcessInstanceEntity processInstanceEntity = (HistoricProcessInstanceEntity)processInstance;
        processInstanceEntity.setLocalizedName(null);
        processInstanceEntity.setLocalizedDescription(null);
        if (this.locale != null && processInstance.getProcessDefinitionId() != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(this.locale, (processDefinition = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager().findDeployedProcessDefinitionById(processInstanceEntity.getProcessDefinitionId())).getKey(), processInstanceEntity.getProcessDefinitionId(), this.withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                processInstanceEntity.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                processInstanceEntity.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }

    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        for (HistoricProcessInstanceQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeProcessVariables) {
            ((HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.INCLUDED_VARIABLE_TIME)).asc();
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public boolean isOpen() {
        return this.unfinished;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public List<String> getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public String getProcessDefinitionIdLike() {
        return this.processDefinitionKey + ":%:%";
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionCategory() {
        return this.processDefinitionCategory;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public boolean isExcludeSubprocesses() {
        return this.excludeSubprocesses;
    }

    public List<String> getProcessKeyNotIn() {
        return this.processKeyNotIn;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public Set<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isNotDeleted() {
        return this.notDeleted;
    }

    public boolean isIncludeProcessVariables() {
        return this.includeProcessVariables;
    }

    public boolean isWithException() {
        return this.withJobException;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public List<HistoricProcessInstanceQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }
}

