/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

public class MustChangePasswordFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SecurityContextHolderAwareRequestWrapper) {
            boolean isMustChangePassword = SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(authority -> "MUST_CHANGE_PASSWORD".equals(authority.getAuthority()));
            SecurityContextHolderAwareRequestWrapper wrapper = (SecurityContextHolderAwareRequestWrapper)SecurityContextHolderAwareRequestWrapper.class.cast(request);
            if (isMustChangePassword && !"POST".equalsIgnoreCase(wrapper.getMethod()) && !"/users/self/changePassword".equals(wrapper.getPathInfo())) {
                throw new AccessDeniedException("Please change your password first");
            }
        }
        chain.doFilter(request, response);
    }
}

