/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.oidcclient.agent;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.OIDCLoginRequestTO;
import org.apache.syncope.common.rest.api.service.OIDCClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="oidcclientLogin", urlPatterns={"/oidcclient/login"})
public class Login
extends HttpServlet {
    private static final long serialVersionUID = 968480296813639041L;
    protected static final Logger LOG = LoggerFactory.getLogger(Login.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String op = request.getParameter("op");
        SyncopeClient anonymous = (SyncopeClient)request.getServletContext().getAttribute("SyncopeAnonymousClient");
        try {
            String redirectURI = StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/login") + "/code-consumer";
            OIDCLoginRequestTO requestTO = ((OIDCClientService)anonymous.getService(OIDCClientService.class)).createLoginRequest(redirectURI, op);
            request.getSession().setAttribute("state", (Object)requestTO.getState());
            request.getSession().setAttribute("op", (Object)op);
            response.setHeader("Cache-Control", "no-cache, no-store");
            response.setHeader("Pragma", "no-cache");
            response.setStatus(303);
            UriBuilder ub = UriBuilder.fromUri((String)requestTO.getProviderAddress());
            ub.queryParam("client_id", new Object[]{requestTO.getClientId()});
            ub.queryParam("redirect_uri", new Object[]{requestTO.getRedirectURI()});
            ub.queryParam("response_type", new Object[]{requestTO.getResponseType()});
            ub.queryParam("scope", new Object[]{requestTO.getScope()});
            ub.queryParam("state", new Object[]{requestTO.getState()});
            response.setHeader("Location", ub.build(new Object[0]).toASCIIString());
        }
        catch (Exception e) {
            LOG.error("While preparing the Authentication Request", (Throwable)e);
            String errorURL = this.getServletContext().getInitParameter("oidcclient.login.error.url");
            if (errorURL == null) {
                request.setAttribute("exception", (Object)e);
                request.getRequestDispatcher("loginError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                e.printStackTrace(response.getWriter());
            }
            response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
        }
    }
}

