/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.OIDCEntityFactory;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCProviderItem;
import org.apache.syncope.core.persistence.api.entity.OIDCUserTemplate;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAOIDCProvider;
import org.apache.syncope.core.persistence.jpa.entity.JPAOIDCProviderItem;
import org.apache.syncope.core.persistence.jpa.entity.JPAOIDCUserTemplate;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.stereotype.Component;

@Component
public class JPAOIDCEntityFactory
implements OIDCEntityFactory {
    public <E extends Entity> E newEntity(Class<E> reference) {
        PersistenceCapable result;
        if (reference.equals(OIDCProvider.class)) {
            result = new JPAOIDCProvider();
        } else if (reference.equals(OIDCProviderItem.class)) {
            result = new JPAOIDCProviderItem();
        } else if (reference.equals(OIDCUserTemplate.class)) {
            result = new JPAOIDCUserTemplate();
        } else {
            throw new IllegalArgumentException("Could not find a JPA implementation of " + reference.getName());
        }
        if (result instanceof AbstractGeneratedKeyEntity) {
            ((AbstractGeneratedKeyEntity)result).setKey(SecureRandomUtils.generateRandomUUID().toString());
        }
        return (E)result;
    }
}

