/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.sax;

import org.apache.cocoon.xml.sax.ImmutableAttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SAXUtils {
    public static final Attributes EMPTY_ATTRIBUTES = new ImmutableAttributesImpl();

    public static void data(ContentHandler contentHandler, String data) throws SAXException {
        contentHandler.characters(data.toCharArray(), 0, data.length());
    }

    public static void createElement(ContentHandler contentHandler, String localName) throws SAXException {
        SAXUtils.startElement(contentHandler, localName);
        SAXUtils.endElement(contentHandler, localName);
    }

    public static void createElement(ContentHandler contentHandler, String localName, String stringValue) throws SAXException {
        SAXUtils.startElement(contentHandler, localName);
        SAXUtils.data(contentHandler, stringValue);
        SAXUtils.endElement(contentHandler, localName);
    }

    public static void createElement(ContentHandler contentHandler, String localName, Attributes atts) throws SAXException {
        SAXUtils.startElement(contentHandler, localName, atts);
        SAXUtils.endElement(contentHandler, localName);
    }

    public static void createElement(ContentHandler contentHandler, String localName, Attributes atts, String stringValue) throws SAXException {
        SAXUtils.startElement(contentHandler, localName, atts);
        SAXUtils.data(contentHandler, stringValue);
        SAXUtils.endElement(contentHandler, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName) throws SAXException {
        SAXUtils.startElement(contentHandler, namespaceURI, localName);
        SAXUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName, String stringValue) throws SAXException {
        SAXUtils.startElement(contentHandler, namespaceURI, localName);
        SAXUtils.data(contentHandler, stringValue);
        SAXUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName, Attributes atts) throws SAXException {
        SAXUtils.startElement(contentHandler, namespaceURI, localName, atts);
        SAXUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName, Attributes atts, String stringValue) throws SAXException {
        SAXUtils.startElement(contentHandler, namespaceURI, localName, atts);
        SAXUtils.data(contentHandler, stringValue);
        SAXUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void endElement(ContentHandler contentHandler, String localName) throws SAXException {
        contentHandler.endElement("", localName, localName);
    }

    public static void endElement(ContentHandler contentHandler, String namespaceURI, String localName) throws SAXException {
        contentHandler.endElement(namespaceURI, localName, localName);
    }

    public static void startElement(ContentHandler contentHandler, String localName) throws SAXException {
        contentHandler.startElement("", localName, localName, EMPTY_ATTRIBUTES);
    }

    public static void startElement(ContentHandler contentHandler, String namespaceURI, String localName) throws SAXException {
        contentHandler.startElement(namespaceURI, localName, localName, EMPTY_ATTRIBUTES);
    }

    public static void startElement(ContentHandler contentHandler, String localName, Attributes atts) throws SAXException {
        contentHandler.startElement("", localName, localName, atts);
    }

    public static void startElement(ContentHandler contentHandler, String namespaceURI, String localName, Attributes atts) throws SAXException {
        contentHandler.startElement(namespaceURI, localName, localName, atts);
    }
}

