/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="userRequests", path="/api/flowable/userRequests/start/${bpmnProcess}")
public class UserRequestsStartResource
extends BaseResource {
    private static final long serialVersionUID = 7273151109078469253L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        StringValue bpmnProcess = null;
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            PageParameters parameters = attributes.getParameters();
            bpmnProcess = parameters.get("bpmnProcess");
            LOG.debug("Start Flowable User Request from process [{}] for user [{}]", (Object)bpmnProcess, (Object)SyncopeEnduserSession.get().getSelfTO().getUsername());
            if (bpmnProcess.isEmpty()) {
                throw new IllegalArgumentException("Empty bpmnProcess, please provide a value");
            }
            ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).start(bpmnProcess.toString(), null, null);
            response.setStatusCode(Integer.valueOf(Response.Status.NO_CONTENT.getStatusCode()));
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                }
            });
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error starting user request from [{}]", bpmnProcess, (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

