/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.UserRequestWrapper;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="userRequests", path="/api/flowable/userRequests")
public class UserRequestsResource
extends BaseResource {
    private static final long serialVersionUID = 7273151109078469253L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            IRequestParameters requestParameters = attributes.getRequest().getQueryParameters();
            switch (request.getMethod()) {
                case "DELETE": {
                    StringValue executionId = requestParameters.getParameterValue("executionId");
                    StringValue reason = requestParameters.getParameterValue("reason");
                    LOG.debug("Cancel Flowable User Request with execution id [{}] for user [{}] with reason [{}]", new Object[]{executionId, SyncopeEnduserSession.get().getSelfTO().getUsername(), reason});
                    if (executionId.isEmpty()) {
                        throw new IllegalArgumentException("Empty executionId, please provide a value");
                    }
                    ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).cancel(executionId.toString(), reason.toString());
                    response.setStatusCode(Integer.valueOf(Response.Status.NO_CONTENT.getStatusCode()));
                    response.setWriteCallback(new AbstractResource.WriteCallback(){

                        public void writeData(IResource.Attributes attributes) throws IOException {
                        }
                    });
                    break;
                }
                case "GET": {
                    StringValue page = requestParameters.getParameterValue("page");
                    StringValue size = requestParameters.getParameterValue("size");
                    StringValue withForm = requestParameters.getParameterValue("withForm");
                    LOG.debug("List available Flowable User Requests for user [{}]", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername());
                    final PagedResult<UserRequest> userRequests = withForm.toBoolean(false) ? this.fillWithForms(UserRequestsResource.list(page, size)) : UserRequestsResource.list(page, size);
                    response.setWriteCallback(new AbstractResource.WriteCallback(){

                        public void writeData(IResource.Attributes attributes) throws IOException {
                            attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)userRequests));
                        }
                    });
                    break;
                }
                default: {
                    LOG.error("Method [{}] not supported", (Object)request.getMethod());
                    response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + "Method not supported" + " }}");
                }
            }
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving user requests for [{}]", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private static PagedResult<UserRequest> list(StringValue page, StringValue size) throws NumberFormatException {
        return ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).list((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(SyncopeEnduserSession.get().getSelfTO().getUsername()).page(Integer.valueOf(page.isEmpty() ? 1 : Integer.parseInt(page.toString())))).size(Integer.valueOf(size.isEmpty() ? 10 : Integer.parseInt(size.toString())))).build());
    }

    private PagedResult<UserRequestWrapper> fillWithForms(PagedResult<UserRequest> reqsResult) {
        PagedResult result = new PagedResult();
        result.getResult().addAll(reqsResult.getResult().stream().map(ur -> new UserRequestWrapper((UserRequest)ur, ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).getForm(SyncopeEnduserSession.get().getSelfTO().getUsername(), ur.getTaskId()))).collect(Collectors.toList()));
        result.setPage(reqsResult.getPage());
        result.setSize(reqsResult.getSize());
        result.setTotalCount(reqsResult.getTotalCount());
        result.setPrev(reqsResult.getPrev());
        result.setNext(reqsResult.getNext());
        return result;
    }
}

