/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtils;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.SchemaKeyCheck;

public class SchemaKeyValidator
extends AbstractValidator<SchemaKeyCheck, Object> {
    public boolean isValid(Object object, ConstraintValidatorContext context) {
        String key = null;
        if (object instanceof PlainSchema) {
            key = ((PlainSchema)object).getKey();
        } else if (object instanceof DerSchema) {
            key = ((DerSchema)object).getKey();
        } else if (object instanceof VirSchema) {
            key = ((VirSchema)object).getKey();
        }
        boolean isValid = KEY_PATTERN.matcher(key).matches();
        if (!isValid) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, key)).addPropertyNode("key").addConstraintViolation();
        } else if (JPAAnyUtils.matchesFieldName(key)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, "Schema key not allowed: " + key)).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        return isValid;
    }
}

