/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ExternalResourceCheck;
import org.identityconnectors.framework.common.objects.ObjectClass;

public class ExternalResourceValidator
extends AbstractValidator<ExternalResourceCheck, ExternalResource> {
    private boolean isValid(List<? extends Item> items, ConstraintValidatorContext context) {
        long connObjectKeys = items.stream().filter(Item::isConnObjectKey).count();
        if (connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isValid(OrgUnit orgUnit, ConstraintValidatorContext context) {
        if (orgUnit == null) {
            return true;
        }
        return this.isValid(orgUnit.getItems(), context);
    }

    private boolean isValid(Mapping mapping, ConstraintValidatorContext context) {
        if (mapping == null) {
            return true;
        }
        boolean isValid = true;
        long passwords = mapping.getItems().stream().filter(Item::isPassword).count();
        if (passwords > 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "One password mapping is allowed at most")).addPropertyNode("password.size").addConstraintViolation();
            isValid = false;
        }
        return isValid && this.isValid(mapping.getItems(), context);
    }

    public boolean isValid(ExternalResource resource, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (resource.getKey() == null || !KEY_PATTERN.matcher(resource.getKey()).matches()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, resource.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        HashSet anyTypes = new HashSet();
        HashSet objectClasses = new HashSet();
        boolean validMappings = resource.getProvisions().stream().allMatch(provision -> {
            anyTypes.add(provision.getAnyType());
            if (provision.getObjectClass() != null) {
                objectClasses.add(provision.getObjectClass().getObjectClassValue());
            }
            return this.isValid(provision.getMapping(), context);
        });
        validMappings &= this.isValid(resource.getOrgUnit(), context);
        if (anyTypes.size() < resource.getProvisions().size()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidResource, "Each provision requires a different " + AnyType.class.getSimpleName())).addPropertyNode("provisions").addConstraintViolation();
            return false;
        }
        if (objectClasses.size() < resource.getProvisions().size()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidResource, "Each provision requires a different" + ObjectClass.class.getSimpleName())).addPropertyNode("provisions").addConstraintViolation();
            return false;
        }
        return validMappings;
    }
}

