/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.user;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAPrivilege;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.user.JPALAPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.spring.security.Encryptor;

@Entity
@Table(name="LinkedAccount", uniqueConstraints={@UniqueConstraint(columnNames={"connObjectKeyValue", "resource_id"})})
public class JPALinkedAccount
extends AbstractGeneratedKeyEntity
implements LinkedAccount,
PersistenceCapable {
    private static final long serialVersionUID = -5141654998687601522L;
    public static final String TABLE = "LinkedAccount";
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @NotNull
    private String connObjectKeyValue;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAUser owner;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAExternalResource resource;
    private String username;
    @Enumerated(value=EnumType.STRING)
    private CipherAlgorithm cipherAlgorithm;
    @Column(nullable=true)
    private String password;
    private Boolean suspended = false;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="account")
    @Valid
    private List<JPALAPlainAttr> plainAttrs = new ArrayList<JPALAPlainAttr>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="linked_account_id")}, inverseJoinColumns={@JoinColumn(name="privilege_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"linked_account_id", "privilege_id"})})
    @Valid
    private Set<JPAPrivilege> privileges = new HashSet<JPAPrivilege>();
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$resource$JPAExternalResource;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount;

    public String getConnObjectKeyValue() {
        return JPALinkedAccount.pcGetconnObjectKeyValue(this);
    }

    public void setConnObjectKeyValue(String connObjectKeyValue) {
        JPALinkedAccount.pcSetconnObjectKeyValue(this, connObjectKeyValue);
    }

    public User getOwner() {
        return JPALinkedAccount.pcGetowner(this);
    }

    public void setOwner(User owner) {
        this.checkType(owner, JPAUser.class);
        JPALinkedAccount.pcSetowner(this, (JPAUser)owner);
    }

    public ExternalResource getResource() {
        return JPALinkedAccount.pcGetresource(this);
    }

    public void setResource(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        JPALinkedAccount.pcSetresource(this, (JPAExternalResource)resource);
    }

    public String getUsername() {
        return JPALinkedAccount.pcGetusername(this);
    }

    public void setUsername(String username) {
        JPALinkedAccount.pcSetusername(this, username);
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return JPALinkedAccount.pcGetcipherAlgorithm(this);
    }

    public boolean canDecodePassword() {
        return JPALinkedAccount.pcGetcipherAlgorithm(this) != null && JPALinkedAccount.pcGetcipherAlgorithm(this).isInvertible();
    }

    public String getPassword() {
        return JPALinkedAccount.pcGetpassword(this);
    }

    public void setEncodedPassword(String password, CipherAlgorithm cipherAlgoritm) {
        JPALinkedAccount.pcSetpassword(this, password);
        JPALinkedAccount.pcSetcipherAlgorithm(this, cipherAlgoritm);
    }

    public void setPassword(String password, CipherAlgorithm cipherAlgoritm) {
        try {
            JPALinkedAccount.pcSetpassword(this, ENCRYPTOR.encode(password, cipherAlgoritm));
            JPALinkedAccount.pcSetcipherAlgorithm(this, cipherAlgoritm);
        }
        catch (Exception e) {
            LOG.error("Could not encode password", (Throwable)e);
            JPALinkedAccount.pcSetpassword(this, null);
        }
    }

    public void setSuspended(Boolean suspended) {
        JPALinkedAccount.pcSetsuspended(this, suspended);
    }

    public Boolean isSuspended() {
        return JPALinkedAccount.pcGetsuspended(this);
    }

    public boolean add(LAPlainAttr attr) {
        this.checkType(attr, JPALAPlainAttr.class);
        return JPALinkedAccount.pcGetplainAttrs(this).add((JPALAPlainAttr)attr);
    }

    public boolean remove(LAPlainAttr attr) {
        this.checkType(attr, JPALAPlainAttr.class);
        return JPALinkedAccount.pcGetplainAttrs(this).remove((JPALAPlainAttr)attr);
    }

    public Optional<? extends LAPlainAttr> getPlainAttr(String plainSchema) {
        return this.getPlainAttrs().stream().filter(plainAttr -> plainAttr != null && plainAttr.getSchema() != null && plainSchema.equals(plainAttr.getSchema().getKey())).findFirst();
    }

    public List<? extends LAPlainAttr> getPlainAttrs() {
        return JPALinkedAccount.pcGetplainAttrs(this);
    }

    public boolean add(Privilege privilege) {
        this.checkType(privilege, JPAPrivilege.class);
        return JPALinkedAccount.pcGetprivileges(this).add((JPAPrivilege)privilege);
    }

    public Set<? extends Privilege> getPrivileges() {
        return JPALinkedAccount.pcGetprivileges(this);
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = JPALinkedAccount.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"cipherAlgorithm", "connObjectKeyValue", "owner", "password", "plainAttrs", "privileges", "resource", "suspended", "username"};
        Class[] classArray = new Class[9];
        Class clazz2 = class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm != null ? class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm : (class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm = JPALinkedAccount.class$("org.apache.syncope.common.lib.types.CipherAlgorithm"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPALinkedAccount.class$("java.lang.String"));
        classArray[1] = clazz3;
        Class clazz4 = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPAUser = JPALinkedAccount.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPAUser"));
        classArray[2] = clazz4;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPALinkedAccount.class$("java.lang.String"));
        Class clazz5 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPALinkedAccount.class$("java.util.List"));
        classArray[4] = clazz5;
        Class clazz6 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = JPALinkedAccount.class$("java.util.Set"));
        classArray[5] = clazz6;
        Class clazz7 = class$Lorg$apache$syncope$core$persistence$jpa$entity$resource$JPAExternalResource != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$resource$JPAExternalResource : (class$Lorg$apache$syncope$core$persistence$jpa$entity$resource$JPAExternalResource = JPALinkedAccount.class$("org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource"));
        classArray[6] = clazz7;
        Class clazz8 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPALinkedAccount.class$("java.lang.Boolean"));
        classArray[7] = clazz8;
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPALinkedAccount.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 5, 10, 26, 26, 26};
        Class clazz9 = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount = JPALinkedAccount.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPALinkedAccount"));
        PCRegistry.register((Class)clazz9, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPALinkedAccount", (PersistenceCapable)new JPALinkedAccount());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 121008823;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.cipherAlgorithm = null;
        this.connObjectKeyValue = null;
        this.owner = null;
        this.password = null;
        this.plainAttrs = null;
        this.privileges = null;
        this.resource = null;
        this.suspended = null;
        this.username = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPALinkedAccount jPALinkedAccount = new JPALinkedAccount();
        if (bl) {
            jPALinkedAccount.pcClearFields();
        }
        jPALinkedAccount.pcStateManager = stateManager;
        jPALinkedAccount.pcCopyKeyFieldsFromObjectId(object);
        return jPALinkedAccount;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPALinkedAccount jPALinkedAccount = new JPALinkedAccount();
        if (bl) {
            jPALinkedAccount.pcClearFields();
        }
        jPALinkedAccount.pcStateManager = stateManager;
        return jPALinkedAccount;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.cipherAlgorithm = (CipherAlgorithm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.connObjectKeyValue = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.owner = (JPAUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.plainAttrs = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.privileges = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.resource = (JPAExternalResource)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.suspended = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cipherAlgorithm);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.connObjectKeyValue);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.owner);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.privileges);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.resource);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspended);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPALinkedAccount jPALinkedAccount, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPALinkedAccount, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.cipherAlgorithm = jPALinkedAccount.cipherAlgorithm;
                return;
            }
            case 1: {
                this.connObjectKeyValue = jPALinkedAccount.connObjectKeyValue;
                return;
            }
            case 2: {
                this.owner = jPALinkedAccount.owner;
                return;
            }
            case 3: {
                this.password = jPALinkedAccount.password;
                return;
            }
            case 4: {
                this.plainAttrs = jPALinkedAccount.plainAttrs;
                return;
            }
            case 5: {
                this.privileges = jPALinkedAccount.privileges;
                return;
            }
            case 6: {
                this.resource = jPALinkedAccount.resource;
                return;
            }
            case 7: {
                this.suspended = jPALinkedAccount.suspended;
                return;
            }
            case 8: {
                this.username = jPALinkedAccount.username;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPALinkedAccount jPALinkedAccount = (JPALinkedAccount)object;
        if (jPALinkedAccount.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPALinkedAccount, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPALinkedAccount = JPALinkedAccount.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPALinkedAccount"));
        return clazz;
    }

    private static final CipherAlgorithm pcGetcipherAlgorithm(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.cipherAlgorithm;
        }
        int n = pcInheritedFieldCount + 0;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.cipherAlgorithm;
    }

    private static final void pcSetcipherAlgorithm(JPALinkedAccount jPALinkedAccount, CipherAlgorithm cipherAlgorithm) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.cipherAlgorithm = cipherAlgorithm;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 0, (Object)jPALinkedAccount.cipherAlgorithm, (Object)cipherAlgorithm, 0);
    }

    private static final String pcGetconnObjectKeyValue(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.connObjectKeyValue;
        }
        int n = pcInheritedFieldCount + 1;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.connObjectKeyValue;
    }

    private static final void pcSetconnObjectKeyValue(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.connObjectKeyValue = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 1, jPALinkedAccount.connObjectKeyValue, string, 0);
    }

    private static final JPAUser pcGetowner(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.owner;
        }
        int n = pcInheritedFieldCount + 2;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.owner;
    }

    private static final void pcSetowner(JPALinkedAccount jPALinkedAccount, JPAUser jPAUser) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.owner = jPAUser;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 2, (Object)jPALinkedAccount.owner, (Object)jPAUser, 0);
    }

    private static final String pcGetpassword(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.password;
        }
        int n = pcInheritedFieldCount + 3;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.password;
    }

    private static final void pcSetpassword(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.password = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 3, jPALinkedAccount.password, string, 0);
    }

    private static final List pcGetplainAttrs(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.plainAttrs;
        }
        int n = pcInheritedFieldCount + 4;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.plainAttrs;
    }

    private static final void pcSetplainAttrs(JPALinkedAccount jPALinkedAccount, List list) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.plainAttrs = list;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 4, jPALinkedAccount.plainAttrs, (Object)list, 0);
    }

    private static final Set pcGetprivileges(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.privileges;
        }
        int n = pcInheritedFieldCount + 5;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.privileges;
    }

    private static final void pcSetprivileges(JPALinkedAccount jPALinkedAccount, Set set) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.privileges = set;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 5, jPALinkedAccount.privileges, (Object)set, 0);
    }

    private static final JPAExternalResource pcGetresource(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.resource;
        }
        int n = pcInheritedFieldCount + 6;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.resource;
    }

    private static final void pcSetresource(JPALinkedAccount jPALinkedAccount, JPAExternalResource jPAExternalResource) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.resource = jPAExternalResource;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 6, (Object)jPALinkedAccount.resource, (Object)jPAExternalResource, 0);
    }

    private static final Boolean pcGetsuspended(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.suspended;
        }
        int n = pcInheritedFieldCount + 7;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.suspended;
    }

    private static final void pcSetsuspended(JPALinkedAccount jPALinkedAccount, Boolean bl) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.suspended = bl;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 7, (Object)jPALinkedAccount.suspended, (Object)bl, 0);
    }

    private static final String pcGetusername(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.username;
        }
        int n = pcInheritedFieldCount + 8;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.username;
    }

    private static final void pcSetusername(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.username = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 8, jPALinkedAccount.username, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

