/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Pattern;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.UserException;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainAttrValueCheck;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.Encryptor;

@MappedSuperclass
@PlainAttrValueCheck
public abstract class AbstractPlainAttrValue
extends AbstractGeneratedKeyEntity
implements PlainAttrValue,
PersistenceCapable {
    private static final long serialVersionUID = -9141923816611244785L;
    private static final Pattern SPRING_ENV_PROPERTY = Pattern.compile("^\\$\\{.*\\}$");
    private String stringValue;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateValue;
    private Boolean booleanValue;
    private Long longValue;
    private Double doubleValue;
    @Lob
    private byte[] binaryValue;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue;

    public Boolean getBooleanValue() {
        return AbstractPlainAttrValue.pcGetbooleanValue(this);
    }

    public void setBooleanValue(Boolean booleanValue) {
        AbstractPlainAttrValue.pcSetbooleanValue(this, booleanValue);
    }

    public Date getDateValue() {
        return AbstractPlainAttrValue.pcGetdateValue(this) == null ? null : new Date(AbstractPlainAttrValue.pcGetdateValue(this).getTime());
    }

    public void setDateValue(Date dateValue) {
        AbstractPlainAttrValue.pcSetdateValue(this, dateValue == null ? null : new Date(dateValue.getTime()));
    }

    public Double getDoubleValue() {
        return AbstractPlainAttrValue.pcGetdoubleValue(this);
    }

    public void setDoubleValue(Double doubleValue) {
        AbstractPlainAttrValue.pcSetdoubleValue(this, doubleValue);
    }

    public Long getLongValue() {
        return AbstractPlainAttrValue.pcGetlongValue(this);
    }

    public void setLongValue(Long longValue) {
        AbstractPlainAttrValue.pcSetlongValue(this, longValue);
    }

    public String getStringValue() {
        return AbstractPlainAttrValue.pcGetdateValue(this) == null && AbstractPlainAttrValue.pcGetbooleanValue(this) == null && AbstractPlainAttrValue.pcGetlongValue(this) == null && AbstractPlainAttrValue.pcGetdoubleValue(this) == null && AbstractPlainAttrValue.pcGetbinaryValue(this) == null && AbstractPlainAttrValue.pcGetstringValue(this) == null ? "" : AbstractPlainAttrValue.pcGetstringValue(this);
    }

    public void setStringValue(String stringValue) {
        AbstractPlainAttrValue.pcSetstringValue(this, stringValue);
    }

    public byte[] getBinaryValue() {
        return AbstractPlainAttrValue.pcGetbinaryValue(this);
    }

    public void setBinaryValue(byte[] binaryValue) {
        AbstractPlainAttrValue.pcSetbinaryValue(this, ArrayUtils.clone((byte[])binaryValue));
    }

    protected String getSecretKey(PlainSchema schema) {
        return SPRING_ENV_PROPERTY.matcher(schema.getSecretKey()).matches() ? ApplicationContextProvider.getApplicationContext().getEnvironment().getProperty(StringUtils.substringBetween((String)schema.getSecretKey(), (String)"${", (String)"}")) : schema.getSecretKey();
    }

    public void parseValue(PlainSchema schema, String value) {
        Exception exception = null;
        switch (schema.getType()) {
            case Boolean: {
                this.setBooleanValue(Boolean.parseBoolean(value));
                break;
            }
            case Long: {
                try {
                    this.setLongValue(schema.getConversionPattern() == null ? Long.valueOf(value).longValue() : FormatUtils.parseNumber((String)value, (String)schema.getConversionPattern()).longValue());
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Double: {
                try {
                    this.setDoubleValue(schema.getConversionPattern() == null ? Double.valueOf(value).doubleValue() : FormatUtils.parseNumber((String)value, (String)schema.getConversionPattern()).doubleValue());
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Date: {
                try {
                    this.setDateValue(schema.getConversionPattern() == null ? FormatUtils.parseDate((String)value) : new Date(FormatUtils.parseDate((String)value, (String)schema.getConversionPattern()).getTime()));
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Encrypted: {
                try {
                    this.setStringValue(Encryptor.getInstance((String)this.getSecretKey(schema)).encode(value, schema.getCipherAlgorithm()));
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Binary: {
                this.setBinaryValue(Base64.getDecoder().decode(value));
                break;
            }
            default: {
                this.setStringValue(value);
            }
        }
        if (exception != null) {
            throw new ParsingValidationException("While trying to parse '" + value + "' as " + schema.getKey(), (Throwable)exception);
        }
    }

    public <T> T getValue() {
        return (T)(AbstractPlainAttrValue.pcGetbooleanValue(this) != null ? this.getBooleanValue() : (AbstractPlainAttrValue.pcGetdateValue(this) != null ? this.getDateValue() : (AbstractPlainAttrValue.pcGetdoubleValue(this) != null ? this.getDoubleValue() : (AbstractPlainAttrValue.pcGetlongValue(this) != null ? this.getLongValue() : (AbstractPlainAttrValue.pcGetbinaryValue(this) != null ? (Object)this.getBinaryValue() : this.getStringValue())))));
    }

    private Object getValue(AttrSchemaType type) {
        Object value;
        switch (type) {
            case Boolean: {
                value = this.getBooleanValue();
                break;
            }
            case Long: {
                value = this.getLongValue();
                break;
            }
            case Double: {
                value = this.getDoubleValue();
                break;
            }
            case Date: {
                value = this.getDateValue();
                break;
            }
            case Binary: {
                value = this.getBinaryValue();
                break;
            }
            case Encrypted: 
            case String: 
            case Enum: {
                value = this.getStringValue();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private String getValueAsString(AttrSchemaType type, PlainSchema schema) {
        String result;
        if (this.getValue(type) == null) {
            LOG.warn("Could not find expected value for type {} in {}, reverting to getValue().toString()", (Object)type, (Object)this);
            Object value = this.getValue();
            return value == null ? null : value.toString();
        }
        switch (type) {
            case Boolean: {
                result = this.getBooleanValue().toString();
                break;
            }
            case Long: {
                result = schema == null || schema.getConversionPattern() == null ? this.getLongValue().toString() : FormatUtils.format((long)this.getLongValue(), (String)schema.getConversionPattern());
                break;
            }
            case Double: {
                result = schema == null || schema.getConversionPattern() == null ? this.getDoubleValue().toString() : FormatUtils.format((double)this.getDoubleValue(), (String)schema.getConversionPattern());
                break;
            }
            case Date: {
                result = schema == null || schema.getConversionPattern() == null ? FormatUtils.format((Date)this.getDateValue()) : FormatUtils.format((Date)this.getDateValue(), (boolean)false, (String)schema.getConversionPattern());
                break;
            }
            case Binary: {
                result = Base64.getEncoder().encodeToString(this.getBinaryValue());
                break;
            }
            case Encrypted: {
                if (schema == null || !"ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(schema.getConversionPattern()) || !schema.getCipherAlgorithm().isInvertible()) {
                    result = this.getStringValue();
                    break;
                }
                try {
                    result = Encryptor.getInstance((String)this.getSecretKey(schema)).decode(this.getStringValue(), schema.getCipherAlgorithm());
                }
                catch (Exception e) {
                    LOG.error("Could not decode encrypted value {} for schema {}", new Object[]{this.getStringValue(), schema, e});
                    result = this.getStringValue();
                }
                break;
            }
            default: {
                result = this.getStringValue();
            }
        }
        return result;
    }

    public String getValueAsString() {
        PlainSchema schema = this.getAttr() == null || this.getAttr().getSchema() == null ? null : this.getAttr().getSchema();
        AttrSchemaType type = schema == null || schema.getType() == null ? AttrSchemaType.String : this.getAttr().getSchema().getType();
        return this.getValueAsString(type, schema);
    }

    public String getValueAsString(AttrSchemaType type) {
        return this.getValueAsString(type, this.getAttr() == null || this.getAttr().getSchema() == null ? null : this.getAttr().getSchema());
    }

    public String getValueAsString(PlainSchema schema) {
        return this.getValueAsString(schema.getType(), schema);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getKey()).append((Object)AbstractPlainAttrValue.pcGetstringValue(this)).append((Object)AbstractPlainAttrValue.pcGetdateValue(this)).append((Object)AbstractPlainAttrValue.pcGetbooleanValue(this)).append((Object)AbstractPlainAttrValue.pcGetlongValue(this)).append((Object)AbstractPlainAttrValue.pcGetdoubleValue(this)).append(AbstractPlainAttrValue.pcGetbinaryValue(this)).build();
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = AbstractPlainAttrValue.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"binaryValue", "booleanValue", "dateValue", "doubleValue", "longValue", "stringValue"};
        Class[] classArray = new Class[6];
        Class clazz2 = class$L$B != null ? class$L$B : (class$L$B = AbstractPlainAttrValue.class$("[B"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = AbstractPlainAttrValue.class$("java.lang.Boolean"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AbstractPlainAttrValue.class$("java.util.Date"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = AbstractPlainAttrValue.class$("java.lang.Double"));
        classArray[3] = clazz5;
        Class clazz6 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = AbstractPlainAttrValue.class$("java.lang.Long"));
        classArray[4] = clazz6;
        Class clazz7 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractPlainAttrValue.class$("java.lang.String"));
        classArray[5] = clazz7;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue = AbstractPlainAttrValue.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttrValue"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractPlainAttrValue", null);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 121008823;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.binaryValue = null;
        this.booleanValue = null;
        this.dateValue = null;
        this.doubleValue = null;
        this.longValue = null;
        this.stringValue = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.binaryValue = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.booleanValue = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.dateValue = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.doubleValue = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.longValue = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.stringValue = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.binaryValue);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.booleanValue);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dateValue);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.doubleValue);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.longValue);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.stringValue);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractPlainAttrValue abstractPlainAttrValue, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(abstractPlainAttrValue, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.binaryValue = abstractPlainAttrValue.binaryValue;
                return;
            }
            case 1: {
                this.booleanValue = abstractPlainAttrValue.booleanValue;
                return;
            }
            case 2: {
                this.dateValue = abstractPlainAttrValue.dateValue;
                return;
            }
            case 3: {
                this.doubleValue = abstractPlainAttrValue.doubleValue;
                return;
            }
            case 4: {
                this.longValue = abstractPlainAttrValue.longValue;
                return;
            }
            case 5: {
                this.stringValue = abstractPlainAttrValue.stringValue;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        AbstractPlainAttrValue abstractPlainAttrValue = (AbstractPlainAttrValue)object;
        if (abstractPlainAttrValue.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractPlainAttrValue, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttrValue = AbstractPlainAttrValue.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttrValue"));
        return clazz;
    }

    private static final byte[] pcGetbinaryValue(AbstractPlainAttrValue abstractPlainAttrValue) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            return abstractPlainAttrValue.binaryValue;
        }
        int n = pcInheritedFieldCount + 0;
        abstractPlainAttrValue.pcStateManager.accessingField(n);
        return abstractPlainAttrValue.binaryValue;
    }

    private static final void pcSetbinaryValue(AbstractPlainAttrValue abstractPlainAttrValue, byte[] byArray) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            abstractPlainAttrValue.binaryValue = byArray;
            return;
        }
        abstractPlainAttrValue.pcStateManager.settingObjectField((PersistenceCapable)abstractPlainAttrValue, pcInheritedFieldCount + 0, (Object)abstractPlainAttrValue.binaryValue, (Object)byArray, 0);
    }

    private static final Boolean pcGetbooleanValue(AbstractPlainAttrValue abstractPlainAttrValue) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            return abstractPlainAttrValue.booleanValue;
        }
        int n = pcInheritedFieldCount + 1;
        abstractPlainAttrValue.pcStateManager.accessingField(n);
        return abstractPlainAttrValue.booleanValue;
    }

    private static final void pcSetbooleanValue(AbstractPlainAttrValue abstractPlainAttrValue, Boolean bl) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            abstractPlainAttrValue.booleanValue = bl;
            return;
        }
        abstractPlainAttrValue.pcStateManager.settingObjectField((PersistenceCapable)abstractPlainAttrValue, pcInheritedFieldCount + 1, (Object)abstractPlainAttrValue.booleanValue, (Object)bl, 0);
    }

    private static final Date pcGetdateValue(AbstractPlainAttrValue abstractPlainAttrValue) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            return abstractPlainAttrValue.dateValue;
        }
        int n = pcInheritedFieldCount + 2;
        abstractPlainAttrValue.pcStateManager.accessingField(n);
        return abstractPlainAttrValue.dateValue;
    }

    private static final void pcSetdateValue(AbstractPlainAttrValue abstractPlainAttrValue, Date date) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            abstractPlainAttrValue.dateValue = date;
            return;
        }
        abstractPlainAttrValue.pcStateManager.settingObjectField((PersistenceCapable)abstractPlainAttrValue, pcInheritedFieldCount + 2, (Object)abstractPlainAttrValue.dateValue, (Object)date, 0);
    }

    private static final Double pcGetdoubleValue(AbstractPlainAttrValue abstractPlainAttrValue) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            return abstractPlainAttrValue.doubleValue;
        }
        int n = pcInheritedFieldCount + 3;
        abstractPlainAttrValue.pcStateManager.accessingField(n);
        return abstractPlainAttrValue.doubleValue;
    }

    private static final void pcSetdoubleValue(AbstractPlainAttrValue abstractPlainAttrValue, Double d) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            abstractPlainAttrValue.doubleValue = d;
            return;
        }
        abstractPlainAttrValue.pcStateManager.settingObjectField((PersistenceCapable)abstractPlainAttrValue, pcInheritedFieldCount + 3, (Object)abstractPlainAttrValue.doubleValue, (Object)d, 0);
    }

    private static final Long pcGetlongValue(AbstractPlainAttrValue abstractPlainAttrValue) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            return abstractPlainAttrValue.longValue;
        }
        int n = pcInheritedFieldCount + 4;
        abstractPlainAttrValue.pcStateManager.accessingField(n);
        return abstractPlainAttrValue.longValue;
    }

    private static final void pcSetlongValue(AbstractPlainAttrValue abstractPlainAttrValue, Long l) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            abstractPlainAttrValue.longValue = l;
            return;
        }
        abstractPlainAttrValue.pcStateManager.settingObjectField((PersistenceCapable)abstractPlainAttrValue, pcInheritedFieldCount + 4, (Object)abstractPlainAttrValue.longValue, (Object)l, 0);
    }

    private static final String pcGetstringValue(AbstractPlainAttrValue abstractPlainAttrValue) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            return abstractPlainAttrValue.stringValue;
        }
        int n = pcInheritedFieldCount + 5;
        abstractPlainAttrValue.pcStateManager.accessingField(n);
        return abstractPlainAttrValue.stringValue;
    }

    private static final void pcSetstringValue(AbstractPlainAttrValue abstractPlainAttrValue, String string) {
        if (abstractPlainAttrValue.pcStateManager == null) {
            abstractPlainAttrValue.stringValue = string;
            return;
        }
        abstractPlainAttrValue.pcStateManager.settingStringField((PersistenceCapable)abstractPlainAttrValue, pcInheritedFieldCount + 5, abstractPlainAttrValue.stringValue, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

