/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.jpa.dao.SearchViewSupport;

public class SearchSupport {
    protected final AnyTypeKind anyTypeKind;
    protected boolean nonMandatorySchemas = false;

    public SearchSupport(AnyTypeKind anyTypeKind) {
        this.anyTypeKind = anyTypeKind;
    }

    public SearchView table() {
        String result;
        switch (this.anyTypeKind) {
            case ANY_OBJECT: {
                result = "AnyObject";
                break;
            }
            case GROUP: {
                result = "SyncopeGroup";
                break;
            }
            default: {
                result = "SyncopeUser";
            }
        }
        return new SearchView("t", result);
    }

    public SearchView field() {
        String result;
        switch (this.anyTypeKind) {
            case ANY_OBJECT: {
                result = "anyObject_search";
                break;
            }
            case GROUP: {
                result = "group_search";
                break;
            }
            default: {
                result = "user_search";
            }
        }
        return new SearchView("sv", result);
    }

    public SearchView relationship() {
        String kind = this.anyTypeKind == AnyTypeKind.USER ? "u" : "a";
        return new SearchView("sv" + kind + "m", this.field().name + "_" + kind + "relationship");
    }

    public SearchView membership() {
        String kind = this.anyTypeKind == AnyTypeKind.USER ? "u" : "a";
        return new SearchView("sv" + kind + "m", this.field().name + "_" + kind + "membership");
    }

    public SearchView dyngroupmembership() {
        return new SearchView("sv" + this.anyTypeKind.name() + "dgm", this.anyTypeKind == AnyTypeKind.USER ? "UDynGroupMembers" : "ADynGroupMembers");
    }

    public SearchView role() {
        return new SearchView("svr", this.field().name + "_role");
    }

    public SearchView priv() {
        return new SearchView("svp", this.field().name + "_priv");
    }

    public SearchView dynpriv() {
        return new SearchView("svdp", this.field().name + "_dynpriv");
    }

    public SearchView dynrolemembership() {
        return new SearchView("svdr", "DynRoleMembers");
    }

    public SearchView dynrealmmembership() {
        return new SearchView("svdrealm", "DynRealmMembers");
    }

    public SearchView resource() {
        return new SearchView("svr", this.field().name + "_resource");
    }

    public SearchView groupResource() {
        return new SearchView("svrr", this.field().name + "_group_res");
    }

    public SearchView entitlements() {
        return new SearchView("sve", this.field().name + "_entitlements");
    }

    SearchViewSupport asSearchViewSupport() {
        if (this instanceof SearchViewSupport) {
            return (SearchViewSupport)this;
        }
        throw new IllegalArgumentException("Not an " + SearchViewSupport.class + " instance");
    }

    public static class SearchView {
        protected String alias;
        protected String name;

        protected SearchView(String alias, String name) {
            this.alias = alias;
            this.name = name;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.alias).append((Object)this.name).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SearchView other = (SearchView)obj;
            return new EqualsBuilder().append((Object)this.alias, (Object)other.alias).append((Object)this.name, (Object)other.name).build();
        }
    }
}

