/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.search;

import java.io.IOException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import net.tirasa.connid.bundles.ldap.search.LdapSearchStrategy;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class LdapInternalSearch {
    private final LdapConnection conn;
    private final String filter;
    private final List<String> baseDNs;
    private final LdapSearchStrategy strategy;
    private final SearchControls controls;

    public LdapInternalSearch(LdapConnection conn, String filter, List<String> baseDNs, LdapSearchStrategy strategy, SearchControls controls) {
        this.conn = conn;
        this.filter = StringUtil.isNotBlank((String)filter) ? filter : "(objectClass=*)";
        this.baseDNs = baseDNs;
        this.strategy = strategy;
        this.controls = controls;
    }

    public void execute(LdapSearchResultsHandler handler) {
        try {
            this.strategy.doSearch(this.conn.getInitialContext(), this.baseDNs, this.filter, this.controls, handler);
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public static SearchControls createDefaultSearchControls() {
        SearchControls result = new SearchControls();
        result.setCountLimit(0L);
        result.setDerefLinkFlag(true);
        result.setReturningObjFlag(false);
        result.setTimeLimit(0);
        return result;
    }
}

