/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.commons;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.GroupHelper;
import net.tirasa.connid.bundles.ldap.commons.LdapEntry;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.common.Base64;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public abstract class LdapModifyOperation {
    protected final LdapConnection conn;
    protected final GroupHelper groupHelper;

    public LdapModifyOperation(LdapConnection conn) {
        this.conn = conn;
        this.groupHelper = new GroupHelper(conn);
    }

    protected final void hashPassword(Attribute passwordAttr, String entryDN) {
        String hashAlgorithm = this.conn.getConfiguration().getPasswordHashAlgorithm();
        if (StringUtil.isBlank((String)hashAlgorithm) || "NONE".equalsIgnoreCase(hashAlgorithm)) {
            return;
        }
        try {
            byte[] password = (byte[])passwordAttr.get();
            if (password != null) {
                String newPassword = this.hashBytes(password, hashAlgorithm, entryDN != null ? (long)entryDN.hashCode() : 0L);
                passwordAttr.clear();
                passwordAttr.add(newPassword);
            }
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private String hashBytes(byte[] plain, String algorithm, long randSeed) {
        Object digest;
        String plainPassword = new String(plain);
        if (plainPassword != null && plainPassword.startsWith("{") && (digest = plainPassword.substring(1, plainPassword.indexOf(125))) != null && algorithm.equalsIgnoreCase((String)digest)) {
            return plainPassword;
        }
        digest = null;
        try {
            if (algorithm.equalsIgnoreCase("SSHA") || algorithm.equalsIgnoreCase("SHA")) {
                digest = MessageDigest.getInstance("SHA-1");
            } else if (algorithm.equalsIgnoreCase("SMD5") || algorithm.equalsIgnoreCase("MD5")) {
                digest = MessageDigest.getInstance("MD5");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectorException("Could not find MessageDigest algorithm (" + algorithm + ") implementation");
        }
        if (digest == null) {
            throw new ConnectorException("Unsupported hash algorithm: " + algorithm);
        }
        byte[] salt = new byte[]{};
        if (algorithm.equalsIgnoreCase("SSHA") || algorithm.equalsIgnoreCase("SMD5")) {
            Random rand = new Random();
            rand.setSeed(System.currentTimeMillis() + randSeed);
            salt = new byte[8];
            rand.nextBytes(salt);
        }
        ((MessageDigest)digest).reset();
        ((MessageDigest)digest).update(plain);
        ((MessageDigest)digest).update(salt);
        byte[] hash = ((MessageDigest)digest).digest();
        byte[] hashPlusSalt = new byte[hash.length + salt.length];
        System.arraycopy(hash, 0, hashPlusSalt, 0, hash.length);
        System.arraycopy(salt, 0, hashPlusSalt, hash.length, salt.length);
        StringBuilder result = new StringBuilder(algorithm.length() + hashPlusSalt.length);
        result.append('{');
        result.append(algorithm);
        result.append('}');
        result.append(Base64.encode((byte[])hashPlusSalt));
        return result.toString();
    }

    protected static Set<String> getAttributeValues(String attrName, LdapName entryDN, Attributes attrs) {
        Attribute attr;
        HashSet<String> result = new HashSet<String>();
        if (entryDN != null && !entryDN.isEmpty()) {
            Rdn rdn = entryDN.getRdn(entryDN.size() - 1);
            LdapUtil.addStringAttrValues(rdn.toAttributes(), attrName, result);
        }
        if ((attr = attrs.get(attrName)) != null) {
            try {
                NamingEnumeration<?> attrEnum = attr.getAll();
                while (attrEnum.hasMoreElements()) {
                    result.add((String)attrEnum.nextElement());
                }
            }
            catch (NamingException e) {
                throw new ConnectorException((Throwable)e);
            }
            return result;
        }
        return result.isEmpty() ? null : result;
    }

    protected final String getFirstPosixRefAttr(String entryDN, Set<String> posixRefAttrs) {
        if (CollectionUtil.isEmpty(posixRefAttrs)) {
            throw new ConnectorException(this.conn.format("cannotAddToPosixGroup", null, entryDN, GroupHelper.getPosixRefAttribute()));
        }
        return Collections.min(posixRefAttrs);
    }

    public final class PosixGroupMember {
        private final String entryDN;
        private LdapEntry entry;
        private Set<String> posixRefAttrs;
        private Set<GroupHelper.GroupMembership> posixGroupMemberships;

        public PosixGroupMember(String entryDN) {
            this.entryDN = entryDN;
        }

        public Set<GroupHelper.GroupMembership> getPosixGroupMemberships() {
            if (this.posixGroupMemberships == null) {
                this.posixGroupMemberships = LdapModifyOperation.this.groupHelper.getPosixGroupMemberships(this.getPosixRefAttributes());
            }
            return this.posixGroupMemberships;
        }

        public Set<GroupHelper.GroupMembership> getPosixGroupMembershipsByAttrs(Set<String> posixRefAttrs) {
            HashSet<GroupHelper.GroupMembership> result = new HashSet<GroupHelper.GroupMembership>();
            for (GroupHelper.GroupMembership member : this.getPosixGroupMemberships()) {
                if (!posixRefAttrs.contains(member.getMemberRef())) continue;
                result.add(member);
            }
            return result;
        }

        public Set<GroupHelper.GroupMembership> getPosixGroupMembershipsByGroups(List<String> groupDNs) {
            HashSet<LdapName> groupNames = new HashSet<LdapName>();
            for (String groupDN : groupDNs) {
                groupNames.add(LdapUtil.quietCreateLdapName(groupDN));
            }
            HashSet<GroupHelper.GroupMembership> result = new HashSet<GroupHelper.GroupMembership>();
            for (GroupHelper.GroupMembership member : this.getPosixGroupMemberships()) {
                if (!groupNames.contains(LdapUtil.quietCreateLdapName(member.getGroupDN()))) continue;
                result.add(member);
            }
            return result;
        }

        public Set<String> getPosixRefAttributes() {
            if (this.posixRefAttrs == null) {
                this.posixRefAttrs = LdapModifyOperation.getAttributeValues(GroupHelper.getPosixRefAttribute(), null, this.getLdapEntry().getAttributes());
            }
            return this.posixRefAttrs;
        }

        private LdapEntry getLdapEntry() {
            if (this.entry == null) {
                this.entry = LdapSearches.getEntry(LdapModifyOperation.this.conn, LdapUtil.quietCreateLdapName(this.entryDN), GroupHelper.getPosixRefAttribute());
            }
            return this.entry;
        }
    }
}

