/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VirAttrCacheValue {
    private final List<String> values = new ArrayList<String>();
    private Date creationDate = new Date();
    private Date lastAccessDate = new Date();

    public VirAttrCacheValue(Collection<Object> values) {
        if (values != null) {
            values.forEach(value -> this.values.add(value.toString()));
        }
    }

    public List<String> getValues() {
        this.lastAccessDate = new Date();
        return this.values;
    }

    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    public void forceExpiring() {
        this.creationDate = new Date(0L);
    }

    public Date getLastAccessDate() {
        return new Date(this.lastAccessDate.getTime());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.values).append((Object)this.creationDate).append((Object)this.lastAccessDate).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirAttrCacheValue other = (VirAttrCacheValue)obj;
        return new EqualsBuilder().append(this.values, other.values).append((Object)this.creationDate, (Object)other.creationDate).append((Object)this.lastAccessDate, (Object)other.lastAccessDate).build();
    }

    public String toString() {
        return "VirAttrCacheValue{values=" + this.values + ", creationDate=" + this.creationDate + ", lastAccessDate=" + this.lastAccessDate + '}';
    }
}

