/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.column;

import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.BuilderUtils;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import com.googlecode.wicket.kendo.ui.datatable.editor.IKendoEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Generics;

public abstract class AbstractColumn
implements IColumn {
    private static final long serialVersionUID = 1L;
    static final int WIDTH = -1;
    private final String field;
    private final Integer width;
    private final IModel<String> titleModel;

    public AbstractColumn(String title) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), null, -1);
    }

    public AbstractColumn(String title, int width) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), null, width);
    }

    public AbstractColumn(String title, String field) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), field, -1);
    }

    public AbstractColumn(String title, String field, int width) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), field, width);
    }

    public AbstractColumn(IModel<String> title) {
        this(title, null, -1);
    }

    public AbstractColumn(IModel<String> title, int width) {
        this(title, null, width);
    }

    public AbstractColumn(IModel<String> title, String field) {
        this(title, field, -1);
    }

    public AbstractColumn(IModel<String> title, String field, int width) {
        this.titleModel = title;
        this.field = field;
        this.width = width;
    }

    @Override
    public String getTitle() {
        return (String)this.titleModel.getObject();
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getMinScreenWidth() {
        return 0;
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public Boolean isEncoded() {
        return null;
    }

    @Override
    public IKendoEditor getEditor() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public String getTemplate() {
        return null;
    }

    @Override
    public String getAttributes() {
        return null;
    }

    @Override
    public String getFooterTemplate() {
        return null;
    }

    @Override
    public String getFilterable() {
        return null;
    }

    @Override
    public String getMenu() {
        return null;
    }

    @Override
    public List<String> getAggregates() {
        return Collections.emptyList();
    }

    protected final String getAggregatesAsString() {
        ArrayList aggregates = Generics.newArrayList();
        for (String aggregate : this.getAggregates()) {
            aggregates.add(Options.asString((String)aggregate));
        }
        return ((Object)aggregates).toString();
    }

    @Override
    public String getGroupHeaderTemplate() {
        return null;
    }

    @Override
    public String getGroupFooterTemplate() {
        return null;
    }

    @Override
    public Boolean isEditable() {
        return null;
    }

    @Override
    public Boolean isNullable() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    public Boolean isPopupVisible() {
        return this.isVisible();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        BuilderUtils.append((StringBuilder)builder, (String)"title", (String)this.getTitle());
        builder.append(", ");
        BuilderUtils.append((StringBuilder)builder, (String)"hidden", (Object)(!this.isVisible() ? 1 : 0));
        if (this.getWidth() > 0) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"width", (Object)this.getWidth());
        }
        if (this.getMinScreenWidth() > 0) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"minScreenWidth", (Object)this.getMinScreenWidth());
        }
        if (this.getField() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"field", (String)this.getField());
        }
        if (this.getFormat() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"format", (String)this.getFormat());
        }
        if (this.getTemplate() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"template", (String)this.getTemplate());
        }
        if (this.getAttributes() != null) {
            builder.append(", ");
            builder.append(JSONObject.quote((String)"attributes")).append(": ").append(this.getAttributes());
        }
        if (this.getFooterTemplate() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"footerTemplate", (String)this.getFooterTemplate());
        }
        if (this.getGroupHeaderTemplate() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"groupHeaderTemplate", (String)this.getGroupHeaderTemplate());
        }
        if (this.getGroupFooterTemplate() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"groupFooterTemplate", (String)this.getGroupFooterTemplate());
        }
        if (this.getEditor() != null) {
            builder.append(", ");
            builder.append("\"").append("editor").append("\"").append(": ").append(this.getEditor());
        }
        if (this.isEncoded() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"encoded", (Object)this.isEncoded());
        }
        if (this.isEditable() != null) {
            builder.append(", ");
            builder.append("\"").append("editable").append("\"").append(": function(dataItem) { return ").append(this.isEditable()).append("; }");
        }
        if (this.isPopupVisible() != null) {
            builder.append(", ");
            BuilderUtils.append((StringBuilder)builder, (String)"popupVisible", (Object)this.isPopupVisible());
        }
        if (this.getMenu() != null) {
            builder.append(", ");
            builder.append("\"").append("menu").append("\"").append(": ").append(this.getMenu());
        }
        if (!this.getAggregates().isEmpty()) {
            builder.append(", ");
            builder.append("\"").append("aggregates").append("\"").append(": ").append(this.getAggregatesAsString());
        }
        if (this.getFilterable() != null) {
            builder.append(", ");
            builder.append("\"").append("filterable").append("\"").append(": ").append(this.getFilterable());
        }
        return builder.toString();
    }
}

