/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;

@Tag(name="Users")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="users")
public interface UserService
extends AnyService<UserTO> {
    @Override
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User matching the provided key; if value looks like a UUID then it is interpreted as key, otherwise as a username.", headers={@Header(name="ETag", schema=@Schema(type="string"), description="Opaque identifier for the latest modification made to the entity returned by this endpoint")})})
    public UserTO read(String var1);

    @Override
    public PagedResult<UserTO> search(AnyQuery var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="User successfully created enriched with propagation status information, as Entity,or empty if 'Prefer: return-no-content' was specified", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}, headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the user created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the user created"), @Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull UserTO var1, @DefaultValue(value="true") @QueryParam(value="storePassword") boolean var2);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="User's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @PATCH
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull UserPatch var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="User's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @PUT
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull UserTO var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="User's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @POST
    @Path(value="{key}/status")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response status(@NotNull StatusPatch var1);
}

