/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.azure.AzureConnectorConfiguration;
import net.tirasa.connid.bundles.azure.dto.AssignedLicense;
import net.tirasa.connid.bundles.azure.dto.Group;
import net.tirasa.connid.bundles.azure.dto.License;
import net.tirasa.connid.bundles.azure.dto.PagedGroups;
import net.tirasa.connid.bundles.azure.dto.PagedUsers;
import net.tirasa.connid.bundles.azure.dto.SubscribedSku;
import net.tirasa.connid.bundles.azure.dto.User;
import net.tirasa.connid.bundles.azure.service.AzureService;
import net.tirasa.connid.bundles.azure.utils.AzureAttributes;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="AzureConnector.connector.display", configurationClass=AzureConnectorConfiguration.class)
public class AzureConnector
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<Filter>,
TestOp,
UpdateOp {
    private AzureConnectorConfiguration configuration;
    private Schema schema;
    private static final Log LOG = Log.getLog(AzureConnector.class);
    private AzureService client;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        LOG.ok("Init", new Object[0]);
        this.configuration = (AzureConnectorConfiguration)configuration;
        this.configuration.validate();
        this.client = new AzureService(this.configuration.getAuthority(), this.configuration.getClientId(), this.configuration.getUsername(), this.configuration.getPassword(), this.configuration.getResourceURI(), this.configuration.getDomain());
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        LOG.ok("Configuration cleanup", new Object[0]);
        this.configuration = null;
    }

    public void test() {
        LOG.ok("Test connector", new Object[0]);
        if (this.configuration != null) {
            if (this.client.getAuthenticated() != null) {
                LOG.ok("Test was successfull", new Object[0]);
            } else {
                LOG.error("Error with establishing connection while testing. No authorization data were provided.", new Object[0]);
            }
        } else {
            LOG.error("Error with establishing connection while testing. No instance of the configuration class", new Object[0]);
        }
    }

    public Schema schema() {
        LOG.ok("Building schema definition ", new Object[0]);
        if (this.schema == null) {
            this.schema = AzureAttributes.buildSchema();
        }
        return this.schema;
    }

    public FilterTranslator<Filter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return new FilterTranslator<Filter>(){

            public List<Filter> translate(Filter filter) {
                return Collections.singletonList(filter);
            }
        };
    }

    public void executeQuery(ObjectClass objectClass, Filter query, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector object execute query ", new Object[0]);
        Attribute key = null;
        if (query instanceof EqualsFilter) {
            Attribute filterAttr = ((EqualsFilter)query).getAttribute();
            if (filterAttr instanceof Uid) {
                key = filterAttr;
            } else if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
                key = filterAttr;
            }
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            if (key == null) {
                List<User> users = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() != null ? options.getPageSize() : -1;
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        PagedUsers pagedResult;
                        if (StringUtil.isNotBlank((String)cookie)) {
                            pagedResult = this.client.getAuthenticated().getAllUsersNextPage(pagesSize, cookie, false);
                            users = pagedResult.getUsers();
                            cookie = users.size() > pagesSize ? pagedResult.getSkipToken() : null;
                        } else {
                            pagedResult = this.client.getAuthenticated().getAllUsers(pagesSize);
                            users = pagedResult.getUsers();
                            cookie = pagedResult.getSkipToken();
                        }
                    } else {
                        users = this.client.getAuthenticated().getAllUsers();
                    }
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Users!", e);
                }
                for (User user : users) {
                    handler.handle(this.fromUser(user, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else if (Uid.NAME.equals(key.getName()) || "objectId".equals(key.getName())) {
                User result = null;
                try {
                    result = this.client.getAuthenticated().getUser(AttributeUtil.getAsStringValue((Attribute)key));
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                handler.handle(this.fromUser(result, attributesToGet));
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            if (key == null) {
                List<Group> groups = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() != null ? options.getPageSize() : -1;
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        PagedGroups pagedResult;
                        if (StringUtil.isNotBlank((String)cookie)) {
                            pagedResult = this.client.getAuthenticated().getAllGroupsNextPage(pagesSize, cookie, false);
                            groups = pagedResult.getGroups();
                            cookie = groups.size() > pagesSize ? pagedResult.getSkipToken() : null;
                        } else {
                            pagedResult = this.client.getAuthenticated().getAllGroups(pagesSize);
                            groups = pagedResult.getGroups();
                            cookie = pagedResult.getSkipToken();
                        }
                    } else {
                        groups = this.client.getAuthenticated().getAllGroups();
                    }
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Groups!", e);
                }
                for (Group group : groups) {
                    handler.handle(this.fromGroup(group, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else if (Uid.NAME.equals(key.getName()) || "objectId".equals(key.getName())) {
                Group result = null;
                try {
                    result = this.client.getAuthenticated().getGroup(AttributeUtil.getAsStringValue((Attribute)key));
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Group!", e);
                }
                handler.handle(this.fromGroup(result, attributesToGet));
            }
        } else if (new ObjectClass("azureLicense").equals((Object)objectClass)) {
            if (key == null) {
                List<SubscribedSku> subscribedSkus = null;
                try {
                    subscribedSkus = this.client.getAuthenticated().getCurrentTenantSubscriptions();
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting subscriptions!", e);
                }
                for (SubscribedSku subscribedSku : subscribedSkus) {
                    handler.handle(this.fromLicense(subscribedSku, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(null, -1));
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Resource object create ", new Object[0]);
        if (createAttributes == null || createAttributes.isEmpty()) {
            AzureUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            User user = new User();
            String username = accessor.findString("mailNickname");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            GuardedString password = accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
            String displayName = accessor.findString("displayName");
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            List licenses = accessor.findList("azureLicense");
            try {
                user.setDisplayName(displayName);
                user.setMailNickname(username);
                user.setPassword(password);
                if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                    LOG.warn("{0} attribute value not correct or not found, won't handle User status", new Object[]{OperationalAttributes.ENABLE_NAME});
                } else {
                    user.setAccountEnabled(Boolean.parseBoolean(status.getValue().get(0).toString()));
                }
                user.fromAttributes(createAttributes);
                this.client.getAuthenticated().createUser(user);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create User : " + username, e);
            }
            List groups = accessor.findList(PredefinedAttributes.GROUPS_NAME);
            if (!CollectionUtil.isEmpty((Collection)groups)) {
                for (Object group : groups) {
                    try {
                        this.client.getAuthenticated().addUserToGroup(user.getObjectId(), group.toString());
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e, "Could not add User {0} to Group {1} ", new Object[]{user.getObjectId(), group});
                    }
                }
            }
            if (!CollectionUtil.isEmpty((Collection)licenses)) {
                for (Object license : licenses) {
                    try {
                        this.client.getAuthenticated().assignLicense(user.getObjectId(), License.create(Collections.singletonList(String.class.cast(license)), true));
                    }
                    catch (RuntimeException ex) {
                        LOG.error((Throwable)ex, "While assigning license {0} to user {1}", new Object[]{String.class.cast(license), user});
                    }
                }
            }
            return new Uid(user.getObjectId());
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            String groupName = accessor.findString("mailNickname");
            if (groupName == null) {
                groupName = accessor.findString(Name.NAME);
            }
            String displayName = accessor.findString("displayName");
            Group group = new Group();
            try {
                group.setDisplayName(displayName);
                group.setMailNickname(groupName);
                group.fromAttributes(createAttributes);
                this.client.getAuthenticated().createGroup(group);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create Group : " + groupName, e);
            }
            return new Uid(group.getObjectId());
        }
        LOG.warn("Create of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Resource object delete ", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided {0} ", new Object[]{objectClass});
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                for (Group group : this.client.getAuthenticated().getAllGroupsForUser(uid.getUidValue())) {
                    this.client.getAuthenticated().deleteUserFromGroup(uid.getUidValue(), group.getObjectId());
                }
            }
            catch (Exception e) {
                LOG.error("Could not delete User {0} from Groups", new Object[]{uid.getUidValue()});
            }
            try {
                this.client.getAuthenticated().deleteUser(uid.getUidValue());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                this.client.getAuthenticated().deleteGroup(uid.getUidValue());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not delete Group " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Resource object update ", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            AzureUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Uid returnUid = uid;
            String displayName = accessor.findString("displayName");
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            List licenses = accessor.findList("azureLicense");
            if (displayName == null) {
                AzureUtils.handleGeneralError("The displayName property cannot be cleared during updates");
            }
            User user = new User();
            user.setObjectId(uid.getUidValue());
            if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                LOG.warn("{0} attribute value not correct, can't handle User  status update", new Object[]{OperationalAttributes.ENABLE_NAME});
            } else {
                user.setAccountEnabled(Boolean.parseBoolean(status.getValue().get(0).toString()));
            }
            try {
                user.fromAttributes(replaceAttributes);
                GuardedString password = accessor.getPassword();
                if (password != null) {
                    try {
                        if (user.getPassword() != null || user.getPasswordProfile() != null) {
                            user.setPassword(password);
                        }
                    }
                    catch (Exception e) {
                        AzureUtils.wrapGeneralError("Could not update password for User " + uid.getUidValue(), e);
                    }
                }
                this.client.getAuthenticated().updateUser(user);
                returnUid = new Uid(user.getObjectId());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create User " + uid.getUidValue() + " from attributes ", e);
            }
            HashSet<String> ownGroups = new HashSet<String>();
            try {
                List<Group> ownGroupsResults = this.client.getAuthenticated().getAllGroupsForUser(returnUid.getUidValue());
                for (Group group : ownGroupsResults) {
                    ownGroups.add(group.getObjectId());
                }
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex, "Could not list groups for User {0}", new Object[]{uid.getUidValue()});
            }
            List groups = CollectionUtil.nullAsEmpty((List)accessor.findList(PredefinedAttributes.GROUPS_NAME));
            for (Group group : groups) {
                if (ownGroups.contains(((Object)group).toString())) continue;
                try {
                    this.client.getAuthenticated().addUserToGroup(returnUid.getUidValue(), ((Object)group).toString());
                    LOG.ok("User added to Group: {0} after update", new Object[]{group});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not add User {0} to Group {1} ", new Object[]{returnUid.getUidValue(), group});
                }
            }
            for (String string : ownGroups) {
                if (groups.contains(string)) continue;
                try {
                    this.client.getAuthenticated().deleteUserFromGroup(returnUid.getUidValue(), string);
                    LOG.ok("User removed from group: {0} after update", new Object[]{string});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not remove Group {0} from User {1} ", new Object[]{string, returnUid.getUidValue()});
                }
            }
            User updatedUser = this.client.getAuthenticated().getUser(returnUid.getUidValue());
            if (updatedUser == null) {
                LOG.error("While reading user {0} after update in order to handle licenses update", new Object[]{returnUid.getUidValue()});
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (AssignedLicense assignedLicense : updatedUser.getAssignedLicenses()) {
                    arrayList.add(assignedLicense.getSkuId());
                }
                if (CollectionUtil.isEmpty((Collection)licenses)) {
                    if (!arrayList.isEmpty()) {
                        this.client.getAuthenticated().assignLicense(returnUid.getUidValue(), License.create(arrayList, false));
                    }
                } else {
                    ArrayList toAdd = new ArrayList();
                    ArrayList<String> toRemove = new ArrayList<String>();
                    ArrayList newLicenses = new ArrayList();
                    for (Object license : licenses) {
                        newLicenses.add(String.class.cast(license));
                    }
                    for (String assignedSkuId : arrayList) {
                        if (newLicenses.contains(assignedSkuId)) continue;
                        toRemove.add(assignedSkuId);
                    }
                    for (String newLicense : newLicenses) {
                        if (arrayList.contains(newLicense)) continue;
                        try {
                            this.client.getAuthenticated().assignLicense(user.getObjectId(), License.create(Collections.singletonList(newLicense), true));
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Throwable)ex, "While assigning license {0} to user {1}", new Object[]{newLicense, user});
                        }
                    }
                    if (!toRemove.isEmpty()) {
                        this.client.getAuthenticated().assignLicense(returnUid.getUidValue(), License.create(toRemove, false));
                    }
                }
            }
            return returnUid;
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            Uid returnUid = uid;
            String groupID = accessor.findString("objectId");
            if (groupID == null) {
                groupID = accessor.findString(Name.NAME);
            }
            String mailNickname = accessor.findString("mailNickname");
            String displayName = accessor.findString("displayName");
            Group group = new Group();
            group.setObjectId(uid.getUidValue());
            if (!uid.getUidValue().equals(groupID)) {
                LOG.info("Update - uid value different from Group ID", new Object[0]);
                group.setMailNickname(mailNickname);
                group.setDisplayName(displayName);
            }
            try {
                group.fromAttributes(replaceAttributes);
                this.client.getAuthenticated().updateGroup(group);
                returnUid = new Uid(group.getObjectId());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create Group " + uid.getUidValue() + " from attributes ", e);
            }
            return returnUid;
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public AzureService getClient() {
        return this.client;
    }

    private ConnectorObject fromUser(User user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.getObjectId());
        builder.setName(user.getMailNickname());
        try {
            block2: for (Attribute toAttribute : user.toAttributes()) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (OperationalAttributes.ENABLE_NAME.equals(attributeToGetName) && "accountEnabled".equals(attributeName)) {
                        builder.addAttribute(OperationalAttributes.ENABLE_NAME, (Collection)toAttribute.getValue());
                        continue block2;
                    }
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains(PredefinedAttributes.GROUPS_NAME)) {
            ArrayList<String> groupNames = new ArrayList<String>();
            List<Group> groups = this.client.getAuthenticated().getAllGroupsForUser(user.getObjectId());
            for (Group group : groups) {
                groupNames.add(group.getMailNickname());
            }
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, groupNames)});
        }
        return builder.build();
    }

    private ConnectorObject fromGroup(Group group, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(group.getObjectId());
        builder.setName(group.getMailNickname());
        try {
            block2: for (Attribute toAttribute : group.toAttributes()) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains("objectId")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"objectId", (Object[])new Object[]{group.getObjectId()})});
        }
        return builder.build();
    }

    private ConnectorObject fromLicense(SubscribedSku subscribedSku, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(new ObjectClass("azureLicense"));
        builder.setUid(subscribedSku.getObjectId());
        builder.setName(subscribedSku.getSkuId());
        try {
            block2: for (Attribute toAttribute : subscribedSku.toAttributes()) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains("azureLicense")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"azureLicense", (Object[])new Object[]{subscribedSku.getObjectId()})});
        }
        return builder.build();
    }
}

