/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.BulkDeleteOperation;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.common.engine.impl.db.HasRevision;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.persistence.cache.CachedEntity;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.common.engine.impl.persistence.entity.AlwaysUpdatedPersistentObject;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
implements Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSqlSession.class);
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    protected EntityCache entityCache;
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;
    protected Map<Class<? extends Entity>, Map<String, Entity>> insertedObjects = new HashMap<Class<? extends Entity>, Map<String, Entity>>();
    protected Map<Class<? extends Entity>, Map<String, Entity>> deletedObjects = new HashMap<Class<? extends Entity>, Map<String, Entity>>();
    protected Map<Class<? extends Entity>, List<BulkDeleteOperation>> bulkDeleteOperations = new HashMap<Class<? extends Entity>, List<BulkDeleteOperation>>();
    protected List<Entity> updatedObjects = new ArrayList<Entity>();

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.entityCache = entityCache;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.entityCache = entityCache;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insert(Entity entity) {
        Class<?> clazz;
        if (entity.getId() == null) {
            String id = Context.getCommandContext().getCurrentEngineConfiguration().getIdGenerator().getNextId();
            if (this.dbSqlSessionFactory.isUsePrefixId()) {
                id = entity.getIdPrefix() + id;
            }
            entity.setId(id);
        }
        if (!this.insertedObjects.containsKey(clazz = entity.getClass())) {
            this.insertedObjects.put(clazz, new LinkedHashMap());
        }
        this.insertedObjects.get(clazz).put(entity.getId(), entity);
        this.entityCache.put(entity, false);
        entity.setInserted(true);
    }

    public void update(Entity entity) {
        this.entityCache.put(entity, false);
        entity.setUpdated(true);
    }

    public int update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.getSqlSession().update(updateStatement, parameters);
    }

    public void delete(String statement, Object parameter, Class<? extends Entity> entityClass) {
        if (!this.bulkDeleteOperations.containsKey(entityClass)) {
            this.bulkDeleteOperations.put(entityClass, new ArrayList(1));
        }
        this.bulkDeleteOperations.get(entityClass).add(new BulkDeleteOperation(this.dbSqlSessionFactory.mapStatement(statement), parameter));
    }

    public void delete(Entity entity) {
        Class<?> clazz = entity.getClass();
        if (!this.deletedObjects.containsKey(clazz)) {
            this.deletedObjects.put(clazz, new LinkedHashMap());
        }
        this.deletedObjects.get(clazz).put(entity.getId(), entity);
        entity.setDeleted(true);
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, -1, -1);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, -1, -1);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, -1, -1);
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        parameter.setDatabaseType(this.dbSqlSessionFactory.getDatabaseType());
        return this.selectListWithRawParameter(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectListNoCacheCheck(String statement, Object parameter) {
        return this.selectListWithRawParameter(statement, new ListQueryParameterObject(parameter, -1, -1), false);
    }

    public List selectListWithRawParameterNoCacheCheck(String statement, Object parameter) {
        return this.selectListWithRawParameter(statement, parameter, false);
    }

    public List selectListWithRawParameterNoCacheCheck(String statement, ListQueryParameterObject parameter) {
        parameter.setDatabaseType(this.dbSqlSessionFactory.getDatabaseType());
        return this.selectListWithRawParameter(statement, parameter, false);
    }

    public List selectListNoCacheCheck(String statement, ListQueryParameterObject parameter) {
        ListQueryParameterObject parameterToUse = parameter;
        if (parameterToUse == null) {
            parameterToUse = new ListQueryParameterObject();
        }
        parameterToUse.setDatabaseType(this.dbSqlSessionFactory.getDatabaseType());
        return this.selectListWithRawParameter(statement, parameterToUse, false);
    }

    public List selectListWithRawParameter(String statement, Object parameter) {
        return this.selectListWithRawParameter(statement, parameter, true);
    }

    public List selectListWithRawParameter(String statement, Object parameter, boolean useCache) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        if (useCache) {
            return this.cacheLoadOrStore(loadedObjects);
        }
        return loadedObjects;
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof Entity) {
            Entity loadedObject = (Entity)result;
            result = this.cacheLoadOrStore(loadedObject);
        }
        return result;
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id) {
        return this.selectById(entityClass, id, true);
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id, boolean useCache) {
        Entity entity = null;
        if (useCache && (entity = (Entity)this.entityCache.findInCache(entityClass, id)) != null) {
            return (T)entity;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        entity = (Entity)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (entity == null) {
            return null;
        }
        this.entityCache.put(entity, true);
        return (T)entity;
    }

    protected List cacheLoadOrStore(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!(loadedObjects.get(0) instanceof Entity)) {
            return loadedObjects;
        }
        ArrayList<Entity> filteredObjects = new ArrayList<Entity>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            Entity cachedEntity = this.cacheLoadOrStore((Entity)loadedObject);
            filteredObjects.add(cachedEntity);
        }
        return filteredObjects;
    }

    protected Entity cacheLoadOrStore(Entity entity) {
        Entity cachedEntity = (Entity)this.entityCache.findInCache(entity.getClass(), entity.getId());
        if (cachedEntity != null) {
            return cachedEntity;
        }
        this.entityCache.put(entity, true);
        return entity;
    }

    @Override
    public void flush() {
        this.determineUpdatedObjects();
        this.removeUnnecessaryOperations();
        if (LOGGER.isDebugEnabled()) {
            this.debugFlush();
        }
        this.flushInserts();
        this.flushUpdates();
        this.flushDeletes();
    }

    protected void removeUnnecessaryOperations() {
        for (Class<? extends Entity> entityClass : this.deletedObjects.keySet()) {
            HashSet<String> ids = new HashSet<String>();
            Iterator<Entity> entitiesToDeleteIterator = this.deletedObjects.get(entityClass).values().iterator();
            while (entitiesToDeleteIterator.hasNext()) {
                Entity entityToDelete = entitiesToDeleteIterator.next();
                if (entityToDelete.getId() != null && !ids.contains(entityToDelete.getId())) {
                    ids.add(entityToDelete.getId());
                    continue;
                }
                entitiesToDeleteIterator.remove();
            }
            for (String id : ids) {
                if (!this.insertedObjects.containsKey(entityClass) || !this.insertedObjects.get(entityClass).containsKey(id)) continue;
                this.insertedObjects.get(entityClass).remove(id);
                this.deletedObjects.get(entityClass).remove(id);
            }
        }
    }

    public void determineUpdatedObjects() {
        this.updatedObjects = new ArrayList<Entity>();
        Map<Class<?>, Map<String, CachedEntity>> cachedObjects = this.entityCache.getAllCachedEntities();
        for (Class<?> clazz : cachedObjects.keySet()) {
            Map<String, CachedEntity> classCache = cachedObjects.get(clazz);
            for (CachedEntity cachedObject : classCache.values()) {
                Entity cachedEntity = cachedObject.getEntity();
                if (this.isEntityInserted(cachedEntity) || !(cachedEntity instanceof AlwaysUpdatedPersistentObject) && this.isEntityToBeDeleted(cachedEntity) || !cachedObject.hasChanged()) continue;
                this.updatedObjects.add(cachedEntity);
            }
        }
    }

    protected void debugFlush() {
        LOGGER.debug("Flushing dbSqlSession");
        int nrOfInserts = 0;
        int nrOfUpdates = 0;
        int nrOfDeletes = 0;
        for (Map<String, Entity> map : this.insertedObjects.values()) {
            for (Entity insertedObject : map.values()) {
                LOGGER.debug("  insert {}", (Object)insertedObject);
                ++nrOfInserts;
            }
        }
        for (Entity entity : this.updatedObjects) {
            LOGGER.debug("  update {}", (Object)entity);
            ++nrOfUpdates;
        }
        for (Map map : this.deletedObjects.values()) {
            for (Entity deletedObject : map.values()) {
                LOGGER.debug("  delete {} with id {}", (Object)deletedObject, (Object)deletedObject.getId());
                ++nrOfDeletes;
            }
        }
        for (Collection collection : this.bulkDeleteOperations.values()) {
            for (BulkDeleteOperation bulkDeleteOperation : collection) {
                LOGGER.debug("  {}", (Object)bulkDeleteOperation);
                ++nrOfDeletes;
            }
        }
        LOGGER.debug("flush summary: {} insert, {} update, {} delete.", new Object[]{nrOfInserts, nrOfUpdates, nrOfDeletes});
        LOGGER.debug("now executing flush...");
    }

    public boolean isEntityInserted(Entity entity) {
        return this.isEntityInserted(entity.getClass(), entity.getId());
    }

    public boolean isEntityInserted(Class<?> entityClass, String entityId) {
        return this.insertedObjects.containsKey(entityClass) && this.insertedObjects.get(entityClass).containsKey(entityId);
    }

    public boolean isEntityToBeDeleted(Entity entity) {
        return this.deletedObjects.containsKey(entity.getClass()) && this.deletedObjects.get(entity.getClass()).containsKey(entity.getId()) || entity.isDeleted();
    }

    protected void flushInserts() {
        if (this.insertedObjects.size() == 0) {
            return;
        }
        for (Class<? extends Entity> entityClass : this.dbSqlSessionFactory.getInsertionOrder()) {
            if (!this.insertedObjects.containsKey(entityClass)) continue;
            this.flushInsertEntities(entityClass, this.insertedObjects.get(entityClass).values());
            this.insertedObjects.remove(entityClass);
        }
        if (this.insertedObjects.size() > 0) {
            for (Class<? extends Entity> entityClass : this.insertedObjects.keySet()) {
                this.flushInsertEntities(entityClass, this.insertedObjects.get(entityClass).values());
            }
        }
        this.insertedObjects.clear();
    }

    protected void flushInsertEntities(Class<? extends Entity> entityClass, Collection<Entity> entitiesToInsert) {
        if (entitiesToInsert.size() == 1) {
            this.flushRegularInsert(entitiesToInsert.iterator().next(), entityClass);
        } else if (Boolean.FALSE.equals(this.dbSqlSessionFactory.isBulkInsertable(entityClass))) {
            for (Entity entity : entitiesToInsert) {
                this.flushRegularInsert(entity, entityClass);
            }
        } else {
            this.flushBulkInsert(entitiesToInsert, entityClass);
        }
    }

    protected void flushRegularInsert(Entity entity, Class<? extends Entity> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(entity);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new FlowableException("no insert statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        LOGGER.debug("inserting: {}", (Object)entity);
        this.sqlSession.insert(insertStatement, (Object)entity);
        if (entity instanceof HasRevision) {
            this.incrementRevision(entity);
        }
    }

    protected void flushBulkInsert(Collection<Entity> entities, Class<? extends Entity> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getBulkInsertStatement(clazz);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new FlowableException("no insert statement for " + entities.iterator().next().getClass() + " in the ibatis mapping files");
        }
        Iterator<Entity> entityIterator = entities.iterator();
        Boolean hasRevision = null;
        while (entityIterator.hasNext()) {
            ArrayList<Entity> subList = new ArrayList<Entity>();
            for (int index = 0; entityIterator.hasNext() && index < this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert(); ++index) {
                Entity entity = entityIterator.next();
                subList.add(entity);
                if (hasRevision != null) continue;
                hasRevision = entity instanceof HasRevision;
            }
            this.sqlSession.insert(insertStatement, subList);
        }
        if (hasRevision != null && hasRevision.booleanValue()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                this.incrementRevision(entityIterator.next());
            }
        }
    }

    protected void incrementRevision(Entity insertedObject) {
        HasRevision revisionEntity = (HasRevision)((Object)insertedObject);
        if (revisionEntity.getRevision() == 0) {
            revisionEntity.setRevision(revisionEntity.getRevisionNext());
        }
    }

    protected void flushUpdates() {
        for (Entity updatedObject : this.updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new FlowableException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            LOGGER.debug("updating: {}", (Object)updatedObject);
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (updatedRecords == 0) {
                throw new FlowableOptimisticLockingException(updatedObject + " was updated by another transaction concurrently");
            }
            if (!(updatedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)updatedObject)).setRevision(((HasRevision)((Object)updatedObject)).getRevisionNext());
        }
        this.updatedObjects.clear();
    }

    protected void flushDeletes() {
        if (this.deletedObjects.size() == 0 && this.bulkDeleteOperations.size() == 0) {
            return;
        }
        for (Class<? extends Entity> entityClass : this.dbSqlSessionFactory.getDeletionOrder()) {
            if (this.deletedObjects.containsKey(entityClass)) {
                this.flushDeleteEntities(entityClass, this.deletedObjects.get(entityClass).values());
                this.deletedObjects.remove(entityClass);
            }
            this.flushBulkDeletes(entityClass, this.bulkDeleteOperations.remove(entityClass));
        }
        if (this.deletedObjects.size() > 0) {
            for (Class<? extends Entity> entityClass : this.deletedObjects.keySet()) {
                this.flushDeleteEntities(entityClass, this.deletedObjects.get(entityClass).values());
                this.flushBulkDeletes(entityClass, this.bulkDeleteOperations.remove(entityClass));
            }
        }
        if (!this.bulkDeleteOperations.isEmpty()) {
            this.bulkDeleteOperations.forEach(this::flushBulkDeletes);
        }
        this.deletedObjects.clear();
        this.bulkDeleteOperations.clear();
    }

    protected void flushBulkDeletes(Class<? extends Entity> entityClass, List<BulkDeleteOperation> deleteOperations) {
        if (deleteOperations != null) {
            for (BulkDeleteOperation bulkDeleteOperation : deleteOperations) {
                bulkDeleteOperation.execute(this.sqlSession, entityClass);
            }
        }
    }

    protected void flushDeleteEntities(Class<? extends Entity> entityClass, Collection<Entity> entitiesToDelete) {
        for (Entity entity : entitiesToDelete) {
            String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(entity.getClass());
            if ((deleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new FlowableException("no delete statement for " + entity.getClass() + " in the ibatis mapping files");
            }
            if (entity instanceof HasRevision) {
                int nrOfRowsDeleted = this.sqlSession.delete(deleteStatement, (Object)entity);
                if (nrOfRowsDeleted != 0) continue;
                throw new FlowableOptimisticLockingException(entity + " was updated by another transaction concurrently");
            }
            this.sqlSession.delete(deleteStatement, (Object)entity);
        }
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public String getConnectionMetadataDefaultCatalog() {
        return this.connectionMetadataDefaultCatalog;
    }

    public void setConnectionMetadataDefaultCatalog(String connectionMetadataDefaultCatalog) {
        this.connectionMetadataDefaultCatalog = connectionMetadataDefaultCatalog;
    }

    public String getConnectionMetadataDefaultSchema() {
        return this.connectionMetadataDefaultSchema;
    }

    public void setConnectionMetadataDefaultSchema(String connectionMetadataDefaultSchema) {
        this.connectionMetadataDefaultSchema = connectionMetadataDefaultSchema;
    }
}

