/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.CSVConfPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class CSVPullWizardBuilder
extends AjaxWizardBuilder<CSVPullSpec> {
    private static final long serialVersionUID = -4049787433975145383L;
    private final ReconciliationRestClient restClient = new ReconciliationRestClient();
    private final Model<byte[]> csv = new Model();

    public CSVPullWizardBuilder(CSVPullSpec defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    public CSVPullWizardBuilder setEventSink(IEventSink eventSink) {
        super.setEventSink(eventSink);
        return this;
    }

    protected ArrayList<ProvisioningReport> onApplyInternal(CSVPullSpec modelObject) {
        return this.restClient.pull(modelObject, new ByteArrayInputStream((byte[])this.csv.getObject()));
    }

    @Override
    protected WizardModel buildModelSteps(CSVPullSpec modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Columns(modelObject));
        wizardModel.add((IWizardStep)new PullTask(modelObject));
        return wizardModel;
    }

    public class PullTask
    extends WizardStep {
        private static final long serialVersionUID = -8954789648303078732L;
        private final ImplementationRestClient implRestClient = new ImplementationRestClient();
        private final IModel<List<String>> pullActions = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 4659376149825914247L;

            protected List<String> load() {
                return PullTask.this.implRestClient.list(ImplementationType.PULL_ACTIONS).stream().map(EntityTO::getKey).sorted().collect(Collectors.toList());
            }
        };
        private final IModel<List<String>> pullCorrelationRules = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 4659376149825914247L;

            protected List<String> load() {
                return PullTask.this.implRestClient.list(ImplementationType.PULL_CORRELATION_RULE).stream().map(EntityTO::getKey).sorted().collect(Collectors.toList());
            }
        };

        public PullTask(CSVPullSpec spec) {
            AjaxCheckBoxPanel remediation = new AjaxCheckBoxPanel("remediation", "remediation", (IModel<Boolean>)new PropertyModel((Object)spec, "remediation"), false);
            this.add(new Component[]{remediation});
            AjaxDropDownChoicePanel<MatchingRule> matchingRule = new AjaxDropDownChoicePanel<MatchingRule>("matchingRule", "matchingRule", (IModel<MatchingRule>)new PropertyModel((Object)spec, "matchingRule"), false);
            matchingRule.setChoices(Arrays.asList(MatchingRule.values()));
            this.add(new Component[]{matchingRule});
            AjaxDropDownChoicePanel<UnmatchingRule> unmatchingRule = new AjaxDropDownChoicePanel<UnmatchingRule>("unmatchingRule", "unmatchingRule", (IModel<UnmatchingRule>)new PropertyModel((Object)spec, "unmatchingRule"), false);
            unmatchingRule.setChoices(Arrays.asList(UnmatchingRule.values()));
            this.add(new Component[]{unmatchingRule});
            AjaxPalettePanel provisioningActions = new AjaxPalettePanel.Builder().build("provisioningActions", new PropertyModel((Object)spec, "provisioningActions"), new ListModel((List)this.pullActions.getObject()));
            this.add(new Component[]{provisioningActions});
            AjaxDropDownChoicePanel<ConflictResolutionAction> conflictResolutionAction = new AjaxDropDownChoicePanel<ConflictResolutionAction>("conflictResolutionAction", "conflictResolutionAction", (IModel<ConflictResolutionAction>)new PropertyModel((Object)spec, "conflictResolutionAction"), false);
            conflictResolutionAction.setChoices(Arrays.asList(ConflictResolutionAction.values()));
            conflictResolutionAction.setRequired(true);
            this.add(new Component[]{conflictResolutionAction});
            AjaxDropDownChoicePanel<String> pullCorrelationRule = new AjaxDropDownChoicePanel<String>("pullCorrelationRule", "pullCorrelationRule", (IModel<String>)new PropertyModel((Object)spec, "pullCorrelationRule"), false);
            pullCorrelationRule.setChoices(this.pullCorrelationRules);
            this.add(new Component[]{pullCorrelationRule});
        }
    }

    public class Columns
    extends WizardStep
    implements WizardModel.ICondition {
        private static final long serialVersionUID = -4136764210454067728L;
        private final CSVPullSpec spec;
        private final ListModel<String> columnsModel = new ListModel();

        public Columns(final CSVPullSpec spec) {
            this.spec = spec;
            final RadioGroup keyColumn = new RadioGroup("keyColumn", (IModel)new PropertyModel((Object)spec, "keyColumn"));
            keyColumn.setOutputMarkupId(true);
            keyColumn.setOutputMarkupPlaceholderTag(true);
            keyColumn.setRenderBodyOnly(false);
            keyColumn.setRequired(true);
            this.add(new Component[]{keyColumn});
            keyColumn.add(new Component[]{new ListView<String>("columns", this.columnsModel){
                private static final long serialVersionUID = -9112553137618363167L;

                protected void populateItem(final ListItem<String> item) {
                    item.add(new Component[]{new Label("column", (Serializable)item.getModelObject())});
                    item.add(new Component[]{new Radio("key", (IModel)new Model((Serializable)item.getModelObject()), keyColumn)});
                    item.add(new Component[]{new AjaxCheckBox("ignore", (IModel)new Model()){
                        private static final long serialVersionUID = -6139318907146065915L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            if (spec.getIgnoreColumns().contains(item.getModelObject())) {
                                spec.getIgnoreColumns().remove(item.getModelObject());
                            } else {
                                spec.getIgnoreColumns().add(item.getModelObject());
                            }
                        }
                    }});
                }
            }.setReuseItems(true)});
        }

        public boolean evaluate() {
            if (CSVPullWizardBuilder.this.csv.getObject() != null) {
                String header = StringUtils.substringBefore((String)new String((byte[])CSVPullWizardBuilder.this.csv.getObject()), (String)this.spec.getLineSeparator());
                this.columnsModel.setObject(Stream.of(StringUtils.split((String)header, (char)this.spec.getColumnSeparator())).map(value -> {
                    String unquoted = value;
                    if (unquoted.charAt(0) == this.spec.getQuoteChar()) {
                        unquoted = unquoted.substring(1);
                    }
                    if (unquoted.charAt(unquoted.length() - 1) == this.spec.getQuoteChar()) {
                        unquoted = unquoted.substring(0, unquoted.length() - 1);
                    }
                    return unquoted;
                }).collect(Collectors.toList()));
            }
            return true;
        }
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = -4736870165235853919L;

        public Details(CSVPullSpec spec) {
            FileInputConfig csvFile = new FileInputConfig();
            csvFile.showUpload(false);
            csvFile.showRemove(false);
            csvFile.showPreview(false);
            final BootstrapFileInputField csvUpload = new BootstrapFileInputField("csvUpload", (IModel)new ListModel(new ArrayList()), csvFile);
            csvUpload.setRequired(true);
            csvUpload.setOutputMarkupId(true);
            csvUpload.add(new Behavior[]{new AjaxFormSubmitBehavior("change"){
                private static final long serialVersionUID = 5538299138211283825L;

                protected void onSubmit(AjaxRequestTarget target) {
                    FileUpload uploadedFile = csvUpload.getFileUpload();
                    if (uploadedFile != null) {
                        CSVPullWizardBuilder.this.csv.setObject((Serializable)uploadedFile.getBytes());
                    }
                }
            }});
            this.add(new Component[]{csvUpload});
            this.add(new Component[]{new CSVConfPanel("csvconf", (AbstractCSVSpec)spec)});
        }
    }

    public static enum LineSeparator {
        LF("\n"),
        CR("\r"),
        CRLF("\r\n");

        private final String repr;

        private LineSeparator(String repr) {
            this.repr = repr;
        }

        public String getRepr() {
            return this.repr;
        }

        public static LineSeparator byRepr(String repr) {
            for (LineSeparator value : LineSeparator.values()) {
                if (!value.getRepr().equals(repr)) continue;
                return value;
            }
            return null;
        }
    }
}

