/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.tasks.AnyPropagationTasks;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAttributesDetailsView
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = -4110576026663173545L;
    private static final Logger LOG = LoggerFactory.getLogger(AnyPropagationTasks.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public TaskAttributesDetailsView(BaseModal<?> baseModal, PropagationTaskTO taskTO, PageReference pageRef) {
        Pair info = Pair.of((Object)taskTO.getEntityKey(), (Object)this.getJSONInfo(taskTO));
        JsonEditorPanel jsonPanel = new JsonEditorPanel(null, (IModel)new PropertyModel((Object)info, "value"), true, null){
            private static final long serialVersionUID = -8927036362466990179L;

            @Override
            public void onSubmit(AjaxRequestTarget target) {
                this.modal.close((IPartialPageRequestHandler)target);
            }
        };
        this.add(new Component[]{jsonPanel});
    }

    private String getJSONInfo(PropagationTaskTO taskTO) {
        String json = "";
        try {
            JsonNode list = MAPPER.readTree(taskTO.getAttributes());
            json = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)list);
        }
        catch (IOException ex) {
            LOG.error("Error converting objects to JSON", (Throwable)ex);
        }
        return json;
    }
}

