/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.StatusPatchType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.common.rest.api.service.UserService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class UserRestClient
extends AbstractAnyRestClient<UserTO> {
    private static final long serialVersionUID = -1575748964398293968L;

    @Override
    protected Class<? extends AnyService<UserTO>> getAnyServiceClass() {
        return UserService.class;
    }

    public ProvisioningResult<UserTO> create(UserTO userTO, boolean storePassword) {
        Response response = UserRestClient.getService(UserService.class).create(userTO, storePassword);
        return (ProvisioningResult)response.readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningResult<UserTO> update(String etag, UserPatch patch) {
        ProvisioningResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            result = (ProvisioningResult)UserRestClient.getService(etag, UserService.class).update(patch).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
            UserRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    @Override
    public int count(String realm, String fiql, String type) {
        return UserRestClient.getService(UserService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(realm).fiql(fiql).page(Integer.valueOf(1))).size(Integer.valueOf(1))).build()).getTotalCount();
    }

    @Override
    public List<UserTO> search(String realm, String fiql, int page, int size, SortParam<String> sort, String type) {
        return UserRestClient.getService(UserService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(realm).fiql(fiql).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(UserRestClient.toOrderBy(sort))).details(false).build()).getResult();
    }

    public ProvisioningResult<UserTO> mustChangePassword(String etag, boolean value, String key) {
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(key);
        userPatch.setMustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)value)).build());
        return this.update(etag, userPatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> status(StatusPatchType type, String etag, String userKey, List<StatusBean> statuses) {
        HashMap<String, String> results;
        StatusPatch statusPatch = StatusUtils.statusPatch(statuses).key(userKey).type(type).build();
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            ProvisioningResult provisioningResult = (ProvisioningResult)UserRestClient.getService(etag, UserService.class).status(statusPatch).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(){});
            statuses.forEach(statusBean -> statusBean.setStatus(Status.UNDEFINED));
            results = new HashMap<String, String>();
            provisioningResult.getPropagationStatuses().forEach(propagationStatus -> {
                Boolean enabled;
                results.put(propagationStatus.getResource(), propagationStatus.getStatus().name());
                if (propagationStatus.getAfterObj() != null && (enabled = StatusUtils.isEnabled(propagationStatus.getAfterObj())) != null) {
                    statuses.stream().filter(statusBean -> propagationStatus.getResource().equals(statusBean.getResource())).findFirst().ifPresent(statusBean -> statusBean.setStatus(enabled != false ? Status.ACTIVE : Status.SUSPENDED));
                }
            });
            statuses.stream().filter(statusBean -> "syncope".equals(statusBean.getResource())).findFirst().ifPresent(statusBean -> statusBean.setStatus("suspended".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) ? Status.SUSPENDED : Status.ACTIVE));
            if (statusPatch.isOnSyncope()) {
                results.put("syncope", "suspended".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) && type == StatusPatchType.SUSPEND || "active".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) && type == StatusPatchType.REACTIVATE ? ExecStatus.SUCCESS.name() : ExecStatus.FAILURE.name());
            }
            UserRestClient.resetClient(UserService.class);
        }
        return results;
    }

    public Map<String, String> suspend(String etag, String userKey, List<StatusBean> statuses) {
        return this.status(StatusPatchType.SUSPEND, etag, userKey, statuses);
    }

    public Map<String, String> reactivate(String etag, String userKey, List<StatusBean> statuses) {
        return this.status(StatusPatchType.REACTIVATE, etag, userKey, statuses);
    }
}

