/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PagedConnObjectTOResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.syncope.common.rest.api.service.ResourceService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class ResourceRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6898907679835668987L;

    public Pair<Boolean, String> check(ResourceTO resourceTO) {
        boolean check = false;
        String errorMessage = null;
        try {
            ResourceRestClient.getService(ResourceService.class).check(resourceTO);
            check = true;
        }
        catch (Exception e) {
            LOG.error("Connector not found {}", (Object)resourceTO.getConnector(), (Object)e);
            errorMessage = e.getMessage();
        }
        return Pair.of((Object)check, (Object)errorMessage);
    }

    public ConnObjectTO readConnObject(String resource, String anyTypeKey, String anyKey) {
        return ResourceRestClient.getService(ResourceService.class).readConnObject(resource, anyTypeKey, anyKey);
    }

    public String getConnObjectKeyValue(String resource, String anyTypeKey, String anyKey) {
        try {
            Response response = ResourceRestClient.getService(ResourceService.class).getConnObjectKeyValue(resource, anyTypeKey, anyKey);
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                return response.getHeaderString("X-Syncope-ConnObject-Key");
            }
        }
        catch (Exception e) {
            LOG.debug("Error fetching connector object key", (Throwable)e);
        }
        LOG.error("Unable to determine connector object key value for resource {}, {} and {}", new Object[]{resource, anyTypeKey, anyKey});
        return null;
    }

    public Pair<String, List<ConnObjectTO>> searchConnObjects(String resource, String anyTypeKey, ConnObjectTOQuery.Builder queryBuilder, SortParam<String> sortParam) {
        ArrayList result = new ArrayList();
        String nextPageResultCookie = null;
        try {
            if (sortParam != null) {
                queryBuilder.orderBy(ResourceRestClient.toOrderBy(sortParam));
            }
            PagedConnObjectTOResult list = ResourceRestClient.getService(ResourceService.class).searchConnObjects(resource, anyTypeKey, queryBuilder.build());
            result.addAll(list.getResult());
            nextPageResultCookie = list.getPagedResultsCookie();
        }
        catch (Exception e) {
            LOG.error("While listing objects on {} for any type {}", new Object[]{resource, anyTypeKey, e});
        }
        return Pair.of((Object)nextPageResultCookie, result);
    }

    public ResourceTO read(String name) {
        return ResourceRestClient.getService(ResourceService.class).read(name);
    }

    public List<ResourceTO> list() {
        List resources = Collections.emptyList();
        try {
            resources = ResourceRestClient.getService(ResourceService.class).list();
            resources.sort(Comparator.comparing(ResourceTO::getKey));
        }
        catch (Exception e) {
            LOG.error("Could not fetch the Resource list", (Throwable)e);
        }
        return resources;
    }

    public ResourceTO create(ResourceTO resourceTO) {
        ResourceService service = ResourceRestClient.getService(ResourceService.class);
        Response response = service.create(resourceTO);
        return ResourceRestClient.getObject(service, response.getLocation(), ResourceTO.class);
    }

    public void update(ResourceTO resourceTO) {
        ResourceRestClient.getService(ResourceService.class).update(resourceTO);
    }

    public void delete(String name) {
        ResourceRestClient.getService(ResourceService.class).delete(name);
    }

    public void setLatestSyncToken(String key, String anyType) {
        ResourceRestClient.getService(ResourceService.class).setLatestSyncToken(key, anyType);
    }

    public void removeSyncToken(String key, String anyType) {
        ResourceRestClient.getService(ResourceService.class).removeSyncToken(key, anyType);
    }
}

