/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.reports.ReportletWizardBuilder;
import org.apache.syncope.client.console.reports.ReportletWrapper;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class ReportletDirectoryPanel
extends DirectoryPanel<ReportletWrapper, ReportletWrapper, DirectoryDataProvider<ReportletWrapper>, ReportRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    private final BaseModal<ReportTO> baseModal;
    private final String report;

    public ReportletDirectoryPanel(BaseModal<ReportTO> baseModal, String report, PageReference pageRef) {
        super("content", pageRef, false);
        this.disableCheckBoxes();
        this.baseModal = baseModal;
        this.report = report;
        this.restClient = new ReportRestClient();
        this.enableExitButton();
        this.addNewItemPanelBuilder(new ReportletWizardBuilder(report, new ReportletWrapper(true), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"REPORT_UPDATE");
        this.initResultTable();
    }

    @Override
    protected List<IColumn<ReportletWrapper, String>> getColumns() {
        ArrayList<IColumn<ReportletWrapper, String>> columns = new ArrayList<IColumn<ReportletWrapper, String>>();
        columns.add((IColumn<ReportletWrapper, String>)new PropertyColumn((IModel)new StringResourceModel("reportlet", (Component)this), (Object)"implementationKey", "implementationKey"));
        columns.add((IColumn<ReportletWrapper, String>)new AbstractColumn<ReportletWrapper, String>((IModel)new StringResourceModel("configuration", (Component)this)){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<ReportletWrapper>> cellItem, String componentId, IModel<ReportletWrapper> rowModel) {
                if (((ReportletWrapper)rowModel.getObject()).getConf() == null) {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((ReportletWrapper)rowModel.getObject()).getConf().getClass().getName()))});
                }
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<ReportletWrapper> getActions(final IModel<ReportletWrapper> model) {
        ActionsPanel<ReportletWrapper> panel = super.getActions(model);
        panel.add(new ActionLink<ReportletWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportletWrapper ignore) {
                ReportletDirectoryPanel.this.getTogglePanel().close(target);
                if (((ReportletWrapper)model.getObject()).getConf() == null) {
                    SyncopeConsoleSession.get().info((Serializable)((Object)ReportletDirectoryPanel.this.getString("noConf")));
                } else {
                    ReportletDirectoryPanel.this.send((IEventSink)ReportletDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
                }
            }
        }, ActionLink.ActionType.EDIT, "REPORT_UPDATE");
        panel.add(new ActionLink<ReportletWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportletWrapper ignore) {
                ReportletConf reportlet = ((ReportletWrapper)model.getObject()).getConf();
                try {
                    ReportTO actual = ((ReportRestClient)ReportletDirectoryPanel.this.restClient).read(ReportletDirectoryPanel.this.report);
                    actual.getReportlets().remove(((ReportletWrapper)model.getObject()).getImplementationKey());
                    ((ReportRestClient)ReportletDirectoryPanel.this.restClient).update(actual);
                    SyncopeConsoleSession.get().success((Serializable)((Object)ReportletDirectoryPanel.this.getString("operation_succeeded")));
                    ReportletDirectoryPanel.this.customActionOnFinishCallback(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)reportlet.getName(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ReportletDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "REPORT_DELETE", true);
        return panel;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = new ActionsPanel<Serializable>(componentId, null);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                if (target != null) {
                    ReportletDirectoryPanel.this.customActionOnFinishCallback(target);
                }
            }
        }, ActionLink.ActionType.RELOAD, "TASK_LIST").hideLabel();
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected ReportDataProvider dataProvider() {
        return new ReportDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "reportlet.paginator.rows";
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected class ReportDataProvider
    extends DirectoryDataProvider<ReportletWrapper> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final ImplementationRestClient implementationClient;
        private final SortableDataProviderComparator<ReportletWrapper> comparator;

        public ReportDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.implementationClient = new ImplementationRestClient();
            this.setSort("implementationKey", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ReportletWrapper>(this);
        }

        private List<ReportletWrapper> getReportletWrappers(ReportTO reportTO) {
            return reportTO.getReportlets().stream().map(reportlet -> {
                ImplementationTO impl = this.implementationClient.read(ImplementationType.REPORTLET, (String)reportlet);
                ReportletWrapper wrapper = new ReportletWrapper(false).setImplementationKey(impl.getKey()).setImplementationEngine(impl.getEngine());
                if (impl.getEngine() == ImplementationEngine.JAVA) {
                    try {
                        ReportletConf reportletConf = (ReportletConf)MAPPER.readValue(impl.getBody(), ReportletConf.class);
                        wrapper.setConf(reportletConf);
                    }
                    catch (Exception e) {
                        LOG.error("During deserialization", (Throwable)e);
                    }
                }
                return wrapper;
            }).filter(wrapper -> wrapper != null).collect(Collectors.toList());
        }

        public Iterator<ReportletWrapper> iterator(long first, long count) {
            ReportTO actual = ((ReportRestClient)ReportletDirectoryPanel.this.restClient).read(ReportletDirectoryPanel.this.report);
            List<ReportletWrapper> reportlets = this.getReportletWrappers(actual);
            Collections.sort(reportlets, this.comparator);
            return reportlets.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            ReportTO actual = ((ReportRestClient)ReportletDirectoryPanel.this.restClient).read(ReportletDirectoryPanel.this.report);
            return this.getReportletWrappers(actual).size();
        }

        public IModel<ReportletWrapper> model(ReportletWrapper object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

